/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamAction
implements Writeable,
ToXContentObject {
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField FAILURE_STORE = new ParseField("failure_store", new String[0]);
    private static final ParseField ADD_BACKING_INDEX = new ParseField("add_backing_index", new String[0]);
    private static final ParseField REMOVE_BACKING_INDEX = new ParseField("remove_backing_index", new String[0]);
    private final Type type;
    private String dataStream;
    private String index;
    private boolean failureStore = false;
    private static final ObjectParser<DataStreamAction, Void> ADD_BACKING_INDEX_PARSER = DataStreamAction.parser(ADD_BACKING_INDEX.getPreferredName(), () -> new DataStreamAction(Type.ADD_BACKING_INDEX));
    private static final ObjectParser<DataStreamAction, Void> REMOVE_BACKING_INDEX_PARSER = DataStreamAction.parser(REMOVE_BACKING_INDEX.getPreferredName(), () -> new DataStreamAction(Type.REMOVE_BACKING_INDEX));
    public static final ConstructingObjectParser<DataStreamAction, Void> PARSER;

    public static DataStreamAction addBackingIndex(String dataStream, String index) {
        return new DataStreamAction(Type.ADD_BACKING_INDEX, dataStream, index, false);
    }

    public static DataStreamAction addFailureStoreIndex(String dataStream, String index) {
        return new DataStreamAction(Type.ADD_BACKING_INDEX, dataStream, index, true);
    }

    public static DataStreamAction removeBackingIndex(String dataStream, String index) {
        return new DataStreamAction(Type.REMOVE_BACKING_INDEX, dataStream, index, false);
    }

    public static DataStreamAction removeFailureStoreIndex(String dataStream, String index) {
        return new DataStreamAction(Type.REMOVE_BACKING_INDEX, dataStream, index, true);
    }

    public DataStreamAction(StreamInput in) throws IOException {
        this.type = Type.fromValue(in.readByte());
        this.dataStream = in.readString();
        this.index = in.readString();
        this.failureStore = in.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0) && in.readBoolean();
    }

    private DataStreamAction(Type type, String dataStream, String index, boolean failureStore) {
        if (!Strings.hasText(dataStream)) {
            throw new IllegalArgumentException("[data_stream] is required");
        }
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("[index] is required");
        }
        this.type = Objects.requireNonNull(type, "[type] must not be null");
        this.dataStream = dataStream;
        this.index = index;
        this.failureStore = failureStore;
    }

    DataStreamAction(Type type) {
        this.type = type;
    }

    public String getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(String datastream) {
        this.dataStream = datastream;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public boolean isFailureStore() {
        return this.failureStore;
    }

    public void setFailureStore(boolean failureStore) {
        this.failureStore = failureStore;
    }

    public Type getType() {
        return this.type;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.type.fieldName);
        builder.field(DATA_STREAM.getPreferredName(), this.dataStream);
        builder.field(INDEX.getPreferredName(), this.index);
        if (DataStream.isFailureStoreFeatureFlagEnabled() && this.failureStore) {
            builder.field(FAILURE_STORE.getPreferredName(), this.failureStore);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.type.value());
        out.writeString(this.dataStream);
        out.writeString(this.index);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
            out.writeBoolean(this.failureStore);
        }
    }

    public static DataStreamAction fromXContent(XContentParser parser) throws IOException {
        return (DataStreamAction)PARSER.apply(parser, null);
    }

    private static ObjectParser<DataStreamAction, Void> parser(String name, Supplier<DataStreamAction> supplier) {
        ObjectParser parser = new ObjectParser(name, supplier);
        return parser;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamAction other = (DataStreamAction)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.dataStream, other.dataStream) && Objects.equals(this.index, other.index) && Objects.equals(this.failureStore, other.failureStore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.dataStream, this.index, this.failureStore});
    }

    static {
        ADD_BACKING_INDEX_PARSER.declareField(DataStreamAction::setDataStream, XContentParser::text, DATA_STREAM, ObjectParser.ValueType.STRING);
        ADD_BACKING_INDEX_PARSER.declareField(DataStreamAction::setIndex, XContentParser::text, INDEX, ObjectParser.ValueType.STRING);
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            ADD_BACKING_INDEX_PARSER.declareField(DataStreamAction::setFailureStore, XContentParser::booleanValue, FAILURE_STORE, ObjectParser.ValueType.BOOLEAN);
        }
        REMOVE_BACKING_INDEX_PARSER.declareField(DataStreamAction::setDataStream, XContentParser::text, DATA_STREAM, ObjectParser.ValueType.STRING);
        REMOVE_BACKING_INDEX_PARSER.declareField(DataStreamAction::setIndex, XContentParser::text, INDEX, ObjectParser.ValueType.STRING);
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            REMOVE_BACKING_INDEX_PARSER.declareField(DataStreamAction::setFailureStore, XContentParser::booleanValue, FAILURE_STORE, ObjectParser.ValueType.BOOLEAN);
        }
        PARSER = new ConstructingObjectParser("data_stream_action", a -> {
            DataStreamAction action = null;
            for (Object o : a) {
                if (o == null) continue;
                if (action == null) {
                    action = (DataStreamAction)o;
                    continue;
                }
                throw new IllegalArgumentException("too many data stream operations declared on operation entry");
            }
            return action;
        });
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ADD_BACKING_INDEX_PARSER, ADD_BACKING_INDEX);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), REMOVE_BACKING_INDEX_PARSER, REMOVE_BACKING_INDEX);
    }

    public static enum Type {
        ADD_BACKING_INDEX(0, ADD_BACKING_INDEX),
        REMOVE_BACKING_INDEX(1, REMOVE_BACKING_INDEX);

        private final byte value;
        private final String fieldName;

        private Type(byte value, ParseField field) {
            this.value = value;
            this.fieldName = field.getPreferredName();
        }

        public byte value() {
            return this.value;
        }

        public static Type fromValue(byte value) {
            return switch (value) {
                case 0 -> ADD_BACKING_INDEX;
                case 1 -> REMOVE_BACKING_INDEX;
                default -> throw new IllegalArgumentException("no data stream action type for [" + value + "]");
            };
        }
    }
}

