/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.RemovePersistentTaskAction;
import org.elasticsearch.persistent.StartPersistentTaskAction;
import org.elasticsearch.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class PersistentTasksService {
    private static final Logger logger = LogManager.getLogger(PersistentTasksService.class);
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public PersistentTasksService(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.client = new OriginSettingClient(client, PERSISTENT_TASK_ORIGIN);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void sendStartRequest(String taskId, String taskName, Params taskParams, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> wrappedListener = listener.map(t -> t);
        this.execute(new StartPersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId, taskName, taskParams), StartPersistentTaskAction.INSTANCE, wrappedListener);
    }

    public void sendCompletionRequest(String taskId, long taskAllocationId, @Nullable Exception taskFailure, @Nullable String localAbortReason, @Nullable TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(new CompletionPersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId, taskAllocationId, taskFailure, localAbortReason), CompletionPersistentTaskAction.INSTANCE, listener);
    }

    void sendCancelRequest(long taskId, String reason, ActionListener<ListTasksResponse> listener) {
        CancelTasksRequest request = new CancelTasksRequest();
        request.setTargetTaskId(new TaskId(this.clusterService.localNode().getId(), taskId));
        request.setReason(reason);
        try {
            this.client.admin().cluster().cancelTasks(request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void sendUpdateStateRequest(String taskId, long taskAllocationID, PersistentTaskState taskState, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(new UpdatePersistentTaskStatusAction.Request(Objects.requireNonNull(timeout), taskId, taskAllocationID, taskState), UpdatePersistentTaskStatusAction.INSTANCE, listener);
    }

    public void sendRemoveRequest(String taskId, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(new RemovePersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId), RemovePersistentTaskAction.INSTANCE, listener);
    }

    private <Req extends ActionRequest, Resp extends PersistentTaskResponse> void execute(Req request, ActionType<Resp> action, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        try {
            this.client.execute(action, request, listener.map(PersistentTaskResponse::getTask));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void waitForPersistentTaskCondition(final String taskId, Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskListener<?> listener) {
        ClusterStateObserver.waitForState(this.clusterService, this.threadPool.getThreadContext(), new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(state, taskId));
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onTimeout(timeout);
            }
        }, clusterState -> predicate.test(PersistentTasksCustomMetadata.getTaskWithId(clusterState, taskId)), timeout, logger);
    }

    public void waitForPersistentTasksCondition(Predicate<PersistentTasksCustomMetadata> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        ClusterStateObserver.waitForState(this.clusterService, this.threadPool.getThreadContext(), new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                listener.onResponse(true);
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onFailure(new IllegalStateException("Timed out when waiting for persistent tasks after " + String.valueOf(timeout)));
            }
        }, clusterState -> predicate.test((PersistentTasksCustomMetadata)clusterState.metadata().custom(PERSISTENT_TASK_ORIGIN)), timeout, logger);
    }

    public static interface WaitForPersistentTaskListener<P extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetadata.PersistentTask<P>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("Timed out when waiting for persistent task after " + String.valueOf(timeout)));
        }
    }
}

