/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class VerifyNodeRepositoryAction {
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("internal:admin/repository/verify");

    private VerifyNodeRepositoryAction() {
    }

    public static class Request
    extends ActionRequest {
        protected final String repository;
        protected final String verificationToken;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        Request(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, ActionResponse.Empty> {
        private final ClusterService clusterService;
        private final RepositoriesService repositoriesService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, RepositoriesService repositoriesService) {
            super(VerifyNodeRepositoryAction.ACTION_NAME, transportService, actionFilters, Request::new, threadPool.executor("snapshot"));
            this.clusterService = clusterService;
            this.repositoriesService = repositoriesService;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<ActionResponse.Empty> listener) {
            DiscoveryNode localNode = this.clusterService.state().nodes().getLocalNode();
            try {
                Repository repository = this.repositoriesService.repository(request.repository);
                repository.verify(request.verificationToken, localNode);
                listener.onResponse(ActionResponse.Empty.INSTANCE);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + request.repository + "] failed to verify repository", (Throwable)e);
                listener.onFailure(e);
            }
        }
    }
}

