/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.file.MasterNodeFileWatchingService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class FileSettingsService
extends MasterNodeFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(FileSettingsService.class);
    public static final String SETTINGS_FILE_NAME = "settings.json";
    public static final String NAMESPACE = "file_settings";
    public static final String OPERATOR_DIRECTORY = "operator";
    private final ReservedClusterStateService stateService;
    private final FileSettingsHealthIndicatorService healthIndicatorService;

    public FileSettingsService(ClusterService clusterService, ReservedClusterStateService stateService, Environment environment, FileSettingsHealthIndicatorService healthIndicatorService) {
        super(clusterService, environment.configDir().toAbsolutePath().resolve(OPERATOR_DIRECTORY).resolve(SETTINGS_FILE_NAME));
        this.stateService = stateService;
        this.healthIndicatorService = healthIndicatorService;
    }

    public FileSettingsHealthIndicatorService healthIndicatorService() {
        return this.healthIndicatorService;
    }

    public void handleSnapshotRestore(ClusterState clusterState, Metadata.Builder mdBuilder) {
        assert (clusterState.nodes().isLocalNodeElectedMaster());
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        if (this.watching() && this.filesExists(this.watchedFile())) {
            if (fileSettingsMetadata != null) {
                ReservedStateMetadata withResetVersion = new ReservedStateMetadata.Builder(fileSettingsMetadata).version(0L).build();
                mdBuilder.put(withResetVersion);
            }
        } else if (fileSettingsMetadata != null) {
            mdBuilder.removeReservedState(fileSettingsMetadata);
        }
    }

    @Override
    protected void doStart() {
        this.healthIndicatorService.startOccurred();
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.healthIndicatorService.stopOccurred();
    }

    @Override
    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        return fileSettingsMetadata != null && fileSettingsMetadata.version().equals(ReservedStateMetadata.RESTORED_VERSION);
    }

    @Override
    protected void processFileChanges() throws ExecutionException, InterruptedException, IOException {
        logger.info("processing path [{}] for [{}]", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.healthIndicatorService.changeOccurred();
        this.processFileChanges(ReservedStateVersionCheck.HIGHER_VERSION_ONLY);
    }

    @Override
    protected void processFileOnServiceStart() throws IOException, ExecutionException, InterruptedException {
        logger.info("processing path [{}] for [{}] on service start", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.healthIndicatorService.changeOccurred();
        this.processFileChanges(ReservedStateVersionCheck.HIGHER_OR_SAME_VERSION);
    }

    private void processFileChanges(ReservedStateVersionCheck versionCheck) throws IOException, InterruptedException, ExecutionException {
        PlainActionFuture completion = new PlainActionFuture();
        try (InputStream fis = this.filesNewInputStream(this.watchedFile());
             BufferedInputStream bis = new BufferedInputStream(fis);
             XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)bis);){
            this.stateService.process(NAMESPACE, parser, versionCheck, e -> this.completeProcessing((Exception)e, completion));
        }
        completion.get();
    }

    private void completeProcessing(Exception e, PlainActionFuture<Void> completion) {
        if (e != null) {
            this.healthIndicatorService.failureOccurred(e.toString());
            completion.onFailure(e);
        } else {
            completion.onResponse(null);
            this.healthIndicatorService.successOccurred();
        }
    }

    @Override
    protected void onProcessFileChangesException(Exception e) {
        if (e instanceof ExecutionException) {
            Throwable cause = e.getCause();
            if (cause instanceof FailedToCommitClusterStateException) {
                logger.error("Unable to commit cluster state", (Throwable)e);
                return;
            }
            if (cause instanceof XContentParseException) {
                logger.error("Unable to parse settings", (Throwable)e);
                return;
            }
            if (cause instanceof NotMasterException) {
                logger.error("Node is no longer master", (Throwable)e);
                return;
            }
        }
        super.onProcessFileChangesException(e);
    }

    @Override
    protected void processInitialFileMissing() throws ExecutionException, InterruptedException, IOException {
        PlainActionFuture<ActionResponse.Empty> completion = new PlainActionFuture<ActionResponse.Empty>();
        logger.info("setting file [{}] not found, initializing [{}] as empty", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.stateService.initEmpty(NAMESPACE, completion);
        completion.get();
    }

    @Override
    protected boolean filesExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    protected boolean filesIsDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    protected <A extends BasicFileAttributes> A filesReadAttributes(Path path, Class<A> clazz) throws IOException {
        return Files.readAttributes(path, clazz, new LinkOption[0]);
    }

    @Override
    protected Stream<Path> filesList(Path dir) throws IOException {
        return Files.list(dir);
    }

    @Override
    protected Path filesSetLastModifiedTime(Path path, FileTime time) throws IOException {
        return Files.setLastModifiedTime(path, time);
    }

    @Override
    protected InputStream filesNewInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static class FileSettingsHealthIndicatorService
    implements HealthIndicatorService {
        static final String NAME = "file_settings";
        static final String INACTIVE_SYMPTOM = "File-based settings are inactive";
        static final String NO_CHANGES_SYMPTOM = "No file-based setting changes have occurred";
        static final String SUCCESS_SYMPTOM = "The most recent file-based settings were applied successfully";
        static final String FAILURE_SYMPTOM = "The most recent file-based settings encountered an error";
        static final List<HealthIndicatorImpact> STALE_SETTINGS_IMPACT = List.of(new HealthIndicatorImpact("file_settings", "stale", 3, "The most recent file-based settings changes have not been applied.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)));
        private boolean isActive = false;
        private long changeCount = 0L;
        private long failureStreak = 0L;
        private String mostRecentFailure = null;

        public synchronized void startOccurred() {
            this.isActive = true;
            this.failureStreak = 0L;
        }

        public synchronized void stopOccurred() {
            this.isActive = false;
            this.mostRecentFailure = null;
        }

        public synchronized void changeOccurred() {
            ++this.changeCount;
        }

        public synchronized void successOccurred() {
            this.failureStreak = 0L;
            this.mostRecentFailure = null;
        }

        public synchronized void failureOccurred(String description) {
            ++this.failureStreak;
            this.mostRecentFailure = description;
        }

        @Override
        public String name() {
            return "file_settings";
        }

        @Override
        public synchronized HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
            if (!this.isActive) {
                return this.createIndicator(HealthStatus.GREEN, INACTIVE_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            if (0L == this.changeCount) {
                return this.createIndicator(HealthStatus.GREEN, NO_CHANGES_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            if (0L == this.failureStreak) {
                return this.createIndicator(HealthStatus.GREEN, SUCCESS_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            return this.createIndicator(HealthStatus.YELLOW, FAILURE_SYMPTOM, new SimpleHealthIndicatorDetails(Map.of("failure_streak", this.failureStreak, "most_recent_failure", this.mostRecentFailure)), STALE_SETTINGS_IMPACT, List.of());
        }
    }
}

