/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rescore.RescoreContext;

public class FetchContext {
    private final SearchContext searchContext;
    private final SourceLoader sourceLoader;
    private final FetchSourceContext fetchSourceContext;
    private final StoredFieldsContext storedFieldsContext;

    public FetchContext(SearchContext searchContext) {
        this.searchContext = searchContext;
        this.sourceLoader = searchContext.newSourceLoader();
        this.storedFieldsContext = FetchContext.buildStoredFieldsContext(searchContext);
        this.fetchSourceContext = FetchContext.buildFetchSourceContext(searchContext);
    }

    private static FetchSourceContext buildFetchSourceContext(SearchContext in) {
        FetchSourceContext fsc = in.fetchSourceContext();
        StoredFieldsContext sfc = in.storedFieldsContext();
        if (fsc == null) {
            boolean hasStoredFields = in.hasStoredFields();
            boolean hasScriptFields = in.hasScriptFields();
            if (!hasStoredFields && !hasScriptFields) {
                fsc = FetchSourceContext.of(true);
            }
        }
        if (sfc != null && sfc.fetchFields()) {
            for (String field : sfc.fieldNames()) {
                if (!"_source".equals(field)) continue;
                fsc = fsc == null ? FetchSourceContext.of(true) : FetchSourceContext.of(true, fsc.includes(), fsc.excludes());
            }
        }
        if (sfc != null && !sfc.fetchFields()) {
            fsc = null;
        }
        return fsc;
    }

    private static StoredFieldsContext buildStoredFieldsContext(SearchContext in) {
        StoredFieldsContext sfc = in.storedFieldsContext();
        if (sfc == null) {
            sfc = StoredFieldsContext.metadataOnly();
        }
        return sfc;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.searchContext.bitsetFilterCache();
    }

    public String getIndexName() {
        return this.searchContext.indexShard().shardId().getIndexName();
    }

    public ContextIndexSearcher searcher() {
        return this.searchContext.searcher();
    }

    public Query query() {
        return this.searchContext.query();
    }

    public Query rewrittenQuery() {
        return this.searchContext.rewrittenQuery();
    }

    public ParsedQuery parsedQuery() {
        return this.searchContext.parsedQuery();
    }

    public ParsedQuery parsedPostFilter() {
        return this.searchContext.parsedPostFilter();
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public StoredFieldsContext storedFieldsContext() {
        return this.storedFieldsContext;
    }

    public boolean explain() {
        return this.searchContext.explain() && this.searchContext.query() != null;
    }

    public List<RescoreContext> rescore() {
        return this.searchContext.rescore();
    }

    public RankBuilder rankBuilder() {
        return this.searchContext.request().source() == null ? null : this.searchContext.request().source().rankBuilder();
    }

    public List<String> queryNames() {
        return this.searchContext.request().source() == null ? Collections.emptyList() : this.searchContext.request().source().subSearches().stream().map(x -> x.getQueryBuilder().queryName()).toList();
    }

    public boolean seqNoAndPrimaryTerm() {
        return this.searchContext.seqNoAndPrimaryTerm();
    }

    public FetchDocValuesContext docValuesContext() {
        FetchDocValuesContext dvContext = this.searchContext.docValuesContext();
        if (this.searchContext.collapse() != null) {
            String name = this.searchContext.collapse().getFieldName();
            if (dvContext == null) {
                return new FetchDocValuesContext(this.searchContext.getSearchExecutionContext(), Collections.singletonList(new FieldAndFormat(name, null)));
            }
            if (this.searchContext.docValuesContext().fields().stream().map(ff -> ff.field).noneMatch(name::equals)) {
                dvContext.fields().add(new FieldAndFormat(name, null));
            }
        }
        return dvContext;
    }

    public SearchHighlightContext highlight() {
        return this.searchContext.highlight();
    }

    public boolean containsBrokenAnalysis(String field) {
        return this.getSearchExecutionContext().containsBrokenAnalysis(field);
    }

    public boolean fetchScores() {
        return this.searchContext.sort() != null && this.searchContext.trackScores();
    }

    public InnerHitsContext innerHits() {
        return this.searchContext.innerHits();
    }

    public boolean version() {
        return this.searchContext.version();
    }

    public FetchFieldsContext fetchFieldsContext() {
        return this.searchContext.fetchFieldsContext();
    }

    public ScriptFieldsContext scriptFields() {
        return this.searchContext.scriptFields();
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchContext.getSearchExt(name);
    }

    public SearchExecutionContext getSearchExecutionContext() {
        return this.searchContext.getSearchExecutionContext();
    }

    public SourceLoader sourceLoader() {
        return this.sourceLoader;
    }

    public Source getRootSource(FetchSubPhase.HitContext hitContext) {
        SearchContext searchContext = this.searchContext;
        if (searchContext instanceof InnerHitsContext.InnerHitSubContext) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)searchContext;
            if (hitContext.hit().getNestedIdentity() != null) {
                return innerHitsContext.getRootLookup();
            }
        }
        return hitContext.source();
    }
}

