/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureResult;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;

public abstract class RankFeaturePhaseRankCoordinatorContext {
    protected final int size;
    protected final int from;
    protected final int rankWindowSize;

    public RankFeaturePhaseRankCoordinatorContext(int size, int from, int rankWindowSize) {
        this.size = size < 0 ? 10 : size;
        this.from = from < 0 ? 0 : from;
        this.rankWindowSize = rankWindowSize;
    }

    protected abstract void computeScores(RankFeatureDoc[] var1, ActionListener<float[]> var2);

    protected RankFeatureDoc[] preprocess(RankFeatureDoc[] originalDocs) {
        return (RankFeatureDoc[])Arrays.stream(originalDocs).sorted(Comparator.comparing(doc -> Float.valueOf(doc.score)).reversed()).toArray(RankFeatureDoc[]::new);
    }

    public void computeRankScoresForGlobalResults(List<RankFeatureResult> rankSearchResults, ActionListener<RankFeatureDoc[]> rankListener) {
        RankFeatureDoc[] featureDocs = this.extractFeatureDocs(rankSearchResults);
        this.computeScores(featureDocs, rankListener.delegateFailureAndWrap((listener, scores) -> {
            for (int i = 0; i < featureDocs.length; ++i) {
                featureDocs[i].score = scores[i];
            }
            listener.onResponse(featureDocs);
        }));
    }

    public RankFeatureDoc[] rankAndPaginate(RankFeatureDoc[] rankFeatureDocs) {
        RankFeatureDoc[] sortedDocs = this.preprocess(rankFeatureDocs);
        RankFeatureDoc[] topResults = new RankFeatureDoc[Math.max(0, Math.min(this.size, sortedDocs.length - this.from))];
        for (int rank = 0; rank < topResults.length; ++rank) {
            topResults[rank] = sortedDocs[this.from + rank];
            topResults[rank].rank = this.from + rank + 1;
        }
        return topResults;
    }

    private RankFeatureDoc[] extractFeatureDocs(List<RankFeatureResult> rankSearchResults) {
        ArrayList<RankFeatureDoc> docFeatures = new ArrayList<RankFeatureDoc>();
        for (RankFeatureResult rankFeatureResult : rankSearchResults) {
            RankFeatureShardResult shardResult = rankFeatureResult.shardResult();
            for (RankFeatureDoc rankFeatureDoc : shardResult.rankFeatureDocs) {
                if (rankFeatureDoc.featureData == null) continue;
                docFeatures.add(rankFeatureDoc);
            }
        }
        return docFeatures.toArray(new RankFeatureDoc[0]);
    }
}

