/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.util;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.xpack.esql.core.type.StringUtils;

public class DateUtils {
    public static final ZoneId UTC = ZoneId.of("Z");
    private static final DateTimeFormatter DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter(Locale.ROOT).withZone(UTC);
    private static final DateTimeFormatter DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter(Locale.ROOT).withZone(UTC);
    public static final String EMPTY = "";
    public static final DateTimeFormatter ISO_DATE_WITH_NANOS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendOffsetId().toFormatter(Locale.ROOT);
    public static final DateTimeFormatter ISO_TIME_WITH_NANOS = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendOffsetId().toFormatter(Locale.ROOT);
    public static final DateFormatter UTC_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"strict_date_optional_time").withZone(UTC);
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;

    private DateUtils() {
    }

    public static ZonedDateTime asDateTimeWithNanos(String dateFormat, ZoneId zoneId) {
        return DateFormatters.from((TemporalAccessor)ISO_DATE_WITH_NANOS.parse(dateFormat)).withZoneSameInstant(zoneId);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).format(ISO_DATE_WITH_NANOS);
        }
        if (value instanceof OffsetTime) {
            return ((OffsetTime)value).format(ISO_TIME_WITH_NANOS);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toInstant().toString();
        }
        if (value instanceof Period) {
            Period p = (Period)value;
            StringBuilder sb = new StringBuilder(7);
            if (p.isNegative()) {
                sb.append("-");
                p = p.negated();
            } else {
                sb.append("+");
            }
            sb.append(p.getYears());
            sb.append("-");
            sb.append(p.getMonths());
            return sb.toString();
        }
        if (value instanceof Duration) {
            Duration d = (Duration)value;
            StringBuilder sb = new StringBuilder(23);
            if (d.isNegative()) {
                sb.append("-");
                d = d.negated();
            } else {
                sb.append("+");
            }
            long durationInSec = d.getSeconds();
            sb.append(durationInSec / 86400L);
            sb.append(" ");
            sb.append(DateUtils.indent((durationInSec %= 86400L) / 3600L));
            sb.append(":");
            sb.append(DateUtils.indent((durationInSec %= 3600L) / 60L));
            sb.append(":");
            sb.append(DateUtils.indent(durationInSec %= 60L));
            long millis = TimeUnit.NANOSECONDS.toMillis(d.getNano());
            if (millis > 0L) {
                sb.append(".");
                while (millis % 10L == 0L) {
                    millis /= 10L;
                }
                sb.append(millis);
            }
            return sb.toString();
        }
        return Objects.toString(value);
    }

    private static String indent(long timeUnit) {
        return timeUnit < 10L ? "0" + timeUnit : Long.toString(timeUnit);
    }

    public static ZonedDateTime asDateTime(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }

    public static ZonedDateTime asDateTime(Instant instant) {
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    public static long asMillis(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static ZonedDateTime asDateTime(String dateFormat) {
        int separatorIdx = dateFormat.indexOf(45);
        if (separatorIdx == 0) {
            separatorIdx = dateFormat.indexOf(45, 1);
        }
        if ((separatorIdx = dateFormat.indexOf(45, separatorIdx + 1) + 3) >= dateFormat.length() || dateFormat.charAt(separatorIdx) == 'T') {
            return DateFormatters.from((TemporalAccessor)DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL.parse(dateFormat)).withZoneSameInstant(UTC);
        }
        return DateFormatters.from((TemporalAccessor)DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE.parse(dateFormat)).withZoneSameInstant(UTC);
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString(dateTime);
    }
}

