/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;

public class TransportWatcherServiceAction
extends AcknowledgedTransportMasterNodeAction<WatcherServiceRequest> {
    private static final Logger logger = LogManager.getLogger(TransportWatcherServiceAction.class);

    @Inject
    public TransportWatcherServiceAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/xpack/watcher/service", transportService, clusterService, threadPool, actionFilters, WatcherServiceRequest::new, (Executor)threadPool.executor("management"));
    }

    protected void masterOperation(Task task, WatcherServiceRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final boolean manuallyStopped = request.getCommand() == WatcherServiceRequest.Command.STOP;
        final String source = manuallyStopped ? "update_watcher_manually_stopped" : "update_watcher_manually_started";
        this.submitUnbatchedTask(source, (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(this, request.masterNodeTimeout(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT, listener){

            public ClusterState execute(ClusterState clusterState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
                WatcherMetadata newWatcherMetadata = new WatcherMetadata(manuallyStopped);
                WatcherMetadata currentMetadata = (WatcherMetadata)clusterState.metadata().custom("watcher");
                if (newWatcherMetadata.equals((Object)currentMetadata)) {
                    return clusterState;
                }
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metadata(Metadata.builder((Metadata)clusterState.getMetadata()).putCustom("watcher", (Metadata.Custom)newWatcherMetadata));
                return builder.build();
            }

            public void onFailure(Exception e) {
                logger.error(() -> Strings.format((String)"could not update watcher stopped status to [%s], source [%s]", (Object[])new Object[]{manuallyStopped, source}), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }
}

