from types import ModuleType
from typing import TypedDict, type_check_only

# NOTE: these 5 are only defined on systems with an intel processor
SSE42: ModuleType | None = ...
FMA3: ModuleType | None = ...
AVX2: ModuleType | None = ...
AVX512F: ModuleType | None = ...
AVX512_SKX: ModuleType | None = ...

# NOTE: these 2 are only defined on systems with an arm processor
ASIMD: ModuleType | None = ...
NEON: ModuleType | None = ...

# NOTE: This is only defined on systems with an riscv64 processor.
RVV: ModuleType | None = ...

baseline: ModuleType | None = ...

@type_check_only
class SimdTargets(TypedDict):
    SSE42: ModuleType | None
    AVX2: ModuleType | None
    FMA3: ModuleType | None
    AVX512F: ModuleType | None
    AVX512_SKX: ModuleType | None
    ASIMD: ModuleType | None
    NEON: ModuleType | None
    RVV: ModuleType | None
    baseline: ModuleType | None

targets: SimdTargets = ...

def clear_floatstatus() -> None: ...
def get_floatstatus() -> int: ...
