# Announce: Rakudo compiler, Release #163 (2023.08)

On behalf of the Rakudo development team, I’m very happy to announce the
August 2023 release of Rakudo #163. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2023.08:

+ Improvements:
    + Re-imagine Formatter + Format updates [2cdab744][3e5a3fb6][672999fd]
      [91f221f0][f6762fa3][6eef82f6][85c83ade][ae149fcc][64e4499a]
      [fe788b0a][90ccaeb5][3cf10fdc][2e53c872][5deb9eed]
    + Improve error message on iterating Ranges that can't be iterated
      [4562d708]
    + Improve null regex error message a bit [19191971]
    + Deprecate including an ambiguous .pm module file [4d5f6ff9]
    + Don't mangle with exception backtrace (related to CompUnit) [e1b5fd0b]
    + Respect CUPR.may-precomp() in CURI [41ae15a0]
    + Optimize .min/.max/.minmax/.minpairs/.maxpairs [1579da00]
    + Make reverse/unlink/rmdir complain when called w/o arguments [bfc5af69]
    + Make X::Syntax::Confused more logical [375d04e3]

+ Additions:
    + Add sprintf(Format:D) candidate for now [120d929b]
    + Add format.directives method [474ca30c]
    + Add Format.AST [9ccd3c37]
    + Add support for Version.new("1,2,3-") [73d07b4b]
    + Make v1.2 eqv v1.2.0.0.0 True [d37e6e83]
    + Implement methods `andthen` and `orelse` on Promise [acd8cc45]
    + Add support for RAKUDO_NO_PRECOMPILATION environment variable [6750ab31]
    + Implement .min|max :k :v :kv :p [ec000772]
    + Implement .(min|max)pairs(&by) + (min|max)(&by, :foo) [4645317d]
    + Implement List.sort(&by?, :k) to return result indices [53edf4e4]
      [53794833]
    + Make sure sub versions of min/max handle adverbs [c5cc2675]
    + Make sure sub sort takes named args and passes them on [e0a882f0]
    + Add X::NoZeroArgMeaning exception class [fc11963d]
    + Add sub versions of WHERE WHICH WHO (#5336) [dbde821f]
    + Add HOW/VAR/WHAT/WHO as Mu methods [7bc98ec4]

+ Fixes:
    + Fix syntax error when building on JVM [53440ad7]
    + Backport threadsafe update of quote-lang cache from RakuAST [60a96bb6]
    + Fix thinko introduced in e6c0b5e919 (DateTime) [b58bf6db]
    + Fix stringification of v6.* [8e394fad]
    + Fix version issues when * was involved [824a500b]
    + Make Regex.gist|raku handle absence of $!source properly [924d5341]
    + Fix use of CALLERS/CALLER pseudo stashes [4cedc949][e334eb56][16ae94c5]
    + Fix a coercion in `Range` constructor [b4b77952]
    + Ensure lock is created before NativeCall role is setup [a4a2bbd2]
    + Make $*KERNEL.bits correct on ARM64 processors [5d4bb333]
    + Fix issue with uint64 Bufs and -1 [43473202]
    + Fix signatures in some Code methods [866099aa]

+ Removals:
    + Remove deprecated --nqp-lib option [55537e9b]
    + Remove deprecated Proc.status [91fdd538]

+ Internal:
    + Fix some cases of improper language revision tests [68dbf929]
    + Increase max heap space to 6G for building jvm rakudo [26e7d650]
    + Remove nqp-home/lib and rakudo-home/lib from vm search paths [4a661911]
      [64fef804]
    + Remove unused transcode compiler option [aca81e92]
    + Don't store a Whatever instance in Version, but a type object [1045f1b2]
    + Make Any.iterator-and-first an implementation detail [99a01075]
    + Introduce Range.Inf-Inf implementation detail method [dbb95d1f]
    + Abstract comparator logic [8157c033]
    + Buglet with dd [8144415a]
    + Allow "sorrows" to be specified as "sorries" [c4b68d7f]
    + Use OperatorProperties.new-compat to set %prec [5fb6d836]

+ RakuAST Development:
    + A lot of work was done on RakuAST development (over 150 commits), raising
      the number of passing spectest files from 884 to 938 (out of 1358).

      [dd55ffe2][0550ae76][3c2af237][fed1515d][93dd19f8][fcf1c3ff][101d3ca5]
      [90aa9c66][2c2c4d4e][c7e6e5af][d72c562d][15f9685b][1beeb166][1b68eb7d]
      [5fa96e37][7d037bbb][b17f9c1c][a31bdc78][5f488afb][ef764677][eb169c3f]
      [84ffe2b1][e36ac593][a05c4061][2184c5a8][d520abb7][a0466136][82cdc95e]
      [f2cbac39][5f03e704][b8a3096b][eb753a3b][564a6df1][126e726d][88b22e2c]
      [743cc08b][5e2c6a39][9fc4f69f][d3a90fc1][1d48d351][6abb6534][d45fb6e5]
      [cfa7f8d7][794d89a4][7b6c81c7][0d641880][c4059d7d][34a1a5da][1c25d071]
      [a8a0416e][c02c07e9][dd009197][9f866810][5fc5c32e][632a2ecc][862e3874]
      [24aa0229][d15d6d7d][6a9e9963][51ebbe80][c002940c][2aca0151][a9e83a93]
      [6c345f4f][d923a4f5][b390e203][defca25f][947b49c9][3bca9516][de7151fa]
      [aed6be5b][bef9ea40][b4d8a48d][977d9bee][baf8906b][0ee02288][52f49344]
      [66d53dcd][ddfe6ae8][ffe631e8][eb60db5d][2588b4cf][01cf0c04][f151aba3]
      [7114b4d7][3072e91e][f325c404][e1f801fc][390b8227][22e78454][20bfeaf2]
      [09b452bf][1cf0b06d][5e353bcd][f7a314b2][c4053f20][4e0ecaa3][edd5d4e7]
      [4afbc34c][5b2f58ba][a0ed2ae9][517e53a5][47577b8a][e4787df9][206c4552]
      [5af65d33][1b44da3e][ec6671d1][4c1ea9fe][652b3050][e13a6b0f][c1b1ae8a]
      [8f612e39][36f561a3][8dd2f004][bdf80215][0e79b375][3e437d76][09a16585]
      [20bd4165][c1f7e4d4][941143d4][011d2ce7][519ec6e8][e20d7b44][0396233a]
      [02a2bd30][512f5cc4][2caaf9f4][f604c788][703363eb][86557c94][205fb661]
      [11334377][34a6c01d][c7ad58de][e6f33599][28d266ff][efb58664][35467a20]
      [5ef70c6a][0ad03b5e][244ea5e9][632f952b][88ca1e38][e5d5d48e][a17588f8]
      [b20c7993][8a7f4b72][1d5a9508][779f0f79][386cac8a][083f2857][32e078ca]
      [d9085270][37aa0544][18786514][dc078bfd][b1f54e17][2dbcdafd]

The following people contributed to this release:

Elizabeth Mattijsen, Will Coleda, Nick Logan, Vadim Belman, Justin DeVuyst,
Stefan Seifert, Tom Browder, Márton Polgár, Brahmajit Das, Daniel Green,
Ikko Eltociear Ashimine, Jan-Olof Hendig, Luis F. Uceta, Salve J. Nilsen,
sergio

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2023 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#164), is tentatively scheduled for 2023-09-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
