/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Set;
import java.util.stream.Collectors;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;

public class ProofRequiredException
extends Exception {
    private final String token;
    private final Set<Option> options;
    private final long retryAfterSeconds;

    public ProofRequiredException(org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException e) {
        this.token = e.getToken();
        this.options = e.getOptions().stream().map(Option::from).collect(Collectors.toSet());
        this.retryAfterSeconds = e.getRetryAfterSeconds();
    }

    public String getToken() {
        return this.token;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public long getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public static enum Option {
        CAPTCHA,
        PUSH_CHALLENGE;


        static Option from(ProofRequiredException.Option option) {
            return switch (option) {
                default -> throw new MatchException(null, null);
                case ProofRequiredException.Option.CAPTCHA -> CAPTCHA;
                case ProofRequiredException.Option.PUSH_CHALLENGE -> PUSH_CHALLENGE;
            };
        }
    }
}

