/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.identities;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.identities.IdentityKeyStore;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.util.IOUtils;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;

public class LegacyIdentityKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacyIdentityKeyStore.class);
    private static final ObjectMapper objectMapper = Utils.createStorageObjectMapper();
    static final Pattern identityFileNamePattern = Pattern.compile("(\\d+)");

    public static void migrate(File identitiesPath, RecipientResolver resolver, RecipientAddressResolver addressResolver, IdentityKeyStore identityKeyStore) {
        List<IdentityInfo> identities = LegacyIdentityKeyStore.getIdentities(identitiesPath, resolver, addressResolver);
        identityKeyStore.addLegacyIdentities(identities);
        LegacyIdentityKeyStore.removeIdentityFiles(identitiesPath);
    }

    private static List<IdentityInfo> getIdentities(File identitiesPath, RecipientResolver resolver, RecipientAddressResolver addressResolver) {
        File[] files = identitiesPath.listFiles();
        if (files == null) {
            return List.of();
        }
        return Arrays.stream(files).filter(f -> identityFileNamePattern.matcher(f.getName()).matches()).map(f -> resolver.resolveRecipient(Long.parseLong(f.getName()))).filter(Objects::nonNull).map(recipientId -> LegacyIdentityKeyStore.loadIdentityLocked(recipientId, addressResolver, identitiesPath)).filter(Objects::nonNull).toList();
    }

    private static File getIdentityFile(RecipientId recipientId, File identitiesPath) {
        try {
            IOUtils.createPrivateDirectories(identitiesPath);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to create identities path", e);
        }
        return new File(identitiesPath, String.valueOf(recipientId.id()));
    }

    private static IdentityInfo loadIdentityLocked(RecipientId recipientId, RecipientAddressResolver addressResolver, File identitiesPath) {
        IdentityInfo identityInfo;
        File file = LegacyIdentityKeyStore.getIdentityFile(recipientId, identitiesPath);
        if (!file.exists()) {
            return null;
        }
        RecipientAddress address = addressResolver.resolveRecipientAddress(recipientId);
        if (address.serviceId().isEmpty()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            IdentityStorage storage = (IdentityStorage)objectMapper.readValue((InputStream)inputStream, IdentityStorage.class);
            IdentityKey id = new IdentityKey(Base64.getDecoder().decode(storage.identityKey()));
            TrustLevel trustLevel = TrustLevel.fromInt(storage.trustLevel());
            long added = storage.addedTimestamp();
            ServiceId serviceId = address.serviceId().get();
            identityInfo = new IdentityInfo(serviceId.toString(), id, trustLevel, added);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidKeyException e) {
                logger.warn("Failed to load identity key: {}", (Object)e.getMessage());
                return null;
            }
        }
        inputStream.close();
        return identityInfo;
    }

    private static void removeIdentityFiles(File identitiesPath) {
        File[] files = identitiesPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete identity file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(identitiesPath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete identity directory {}: {}", (Object)identitiesPath, (Object)e.getMessage());
        }
    }

    public record IdentityStorage(String identityKey, int trustLevel, long addedTimestamp) {
    }
}

