/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

public final class BackpressureHelper {
    private BackpressureHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static long addCap(long a, long b) {
        long u = a + b;
        if (u < 0L) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && u / a != b) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static long add(@NonNull AtomicLong requested, long n) {
        long u;
        long r;
        do {
            if ((r = requested.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
        return r;
    }

    public static long addCancel(@NonNull AtomicLong requested, long n) {
        long u;
        long r;
        do {
            if ((r = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (r != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
        return r;
    }

    public static long produced(@NonNull AtomicLong requested, long n) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }

    public static long producedCancel(@NonNull AtomicLong requested, long n) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (current == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }
}

