/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.api.StickerPackUrl;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadStickerPackCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(UploadStickerPackCommand.class);

    @Override
    public String getName() {
        return "uploadStickerPack";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Upload a new sticker pack, consisting of a manifest file and the stickers images.");
        subparser.addArgument(new String[]{"path"}).help("The path of the manifest.json or a zip file containing the sticker pack you wish to upload.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        File path = new File(ns.getString("path"));
        try {
            StickerPackUrl url = m.uploadStickerPack(path);
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    writer.println("{}", url.getUrl());
                    break;
                }
                case 1: {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    writer.write(Map.of("url", url.getUrl()));
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new IOErrorException("Upload error (maybe image size too large):" + e.getMessage(), e);
        }
        catch (StickerPackInvalidException e) {
            throw new UserErrorException("Invalid sticker pack: " + e.getMessage());
        }
    }
}

