/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Base64;
import java.util.List;
import org.asamk.signal.manager.api.MessageEnvelope;

record JsonCallMessage(@JsonInclude(value=JsonInclude.Include.NON_NULL) Offer offerMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) Answer answerMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) Busy busyMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) Hangup hangupMessage, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) List<IceUpdate> iceUpdateMessages) {
    static JsonCallMessage from(MessageEnvelope.Call callMessage) {
        return new JsonCallMessage(callMessage.offer().map(Offer::from).orElse(null), callMessage.answer().map(Answer::from).orElse(null), callMessage.busy().map(Busy::from).orElse(null), callMessage.hangup().map(Hangup::from).orElse(null), callMessage.iceUpdate().stream().map(IceUpdate::from).toList());
    }

    record Offer(long id, String type, String opaque) {
        public static Offer from(MessageEnvelope.Call.Offer offer) {
            return new Offer(offer.id(), offer.type().name(), Base64.getEncoder().encodeToString(offer.opaque()));
        }
    }

    public record Answer(long id, String opaque) {
        public static Answer from(MessageEnvelope.Call.Answer answer) {
            return new Answer(answer.id(), Base64.getEncoder().encodeToString(answer.opaque()));
        }
    }

    public record Busy(long id) {
        public static Busy from(MessageEnvelope.Call.Busy busy) {
            return new Busy(busy.id());
        }
    }

    public record Hangup(long id, String type, int deviceId) {
        public static Hangup from(MessageEnvelope.Call.Hangup hangup) {
            return new Hangup(hangup.id(), hangup.type().name(), hangup.deviceId());
        }
    }

    public record IceUpdate(long id, String opaque) {
        public static IceUpdate from(MessageEnvelope.Call.IceUpdate iceUpdate) {
            return new IceUpdate(iceUpdate.id(), Base64.getEncoder().encodeToString(iceUpdate.opaque()));
        }
    }
}

