@echo off
rem Author: Jelle Geerts
rem
rem Usage of the works is permitted provided that this instrument is
rem retained with the works, so that any entity that uses the works is
rem notified of this instrument.
rem
rem DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.

setlocal
set exit_with_err=1

set config=-static -D UNICODE

if not "%1" == "release" goto :debug
echo Compiling release build ...
set config=%config% -O3 -s -D NDEBUG
shift
goto :cont
:debug
echo Compiling debug build ...
set config=%config% -O -g -D DEBUG
if "%1" == "debug" shift
:cont

set CXXFLAGS=%CXXFLAGS% ^
-std=c++98 ^
-Wall -Wextra -Werror -Wshadow -Wpointer-arith -Wcast-align ^
-Wwrite-strings -Wredundant-decls -Wformat=2 -Wundef ^
-pedantic -pedantic-errors -Wa,--fatal-warnings

g++ %CXXFLAGS% %config% ^
src\main.cpp ^
src\nowide\nowide.cpp ^
-o example.exe || goto :exit

set exit_with_err=0
echo OK

:exit
if not "%exit_with_err%" == "0" ( \ 2>nul ) else ( cd . )
