/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;

public class SecretSerializationUtil {
    public static void write(DatagramWriter writer, SecretKey key) {
        if (key == null || SecretUtil.isDestroyed(key)) {
            writer.writeVarBytes((byte[])null, 8);
        } else {
            byte[] encoded = key.getEncoded();
            writer.writeVarBytes(encoded, 8);
            Bytes.clear((byte[])encoded);
            SerializationUtil.write((DatagramWriter)writer, (String)key.getAlgorithm(), (int)8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey readSecretKey(DatagramReader reader) {
        SecretKey key = null;
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            if (data.length == 0) {
                throw new IllegalArgumentException("key must not be empty!");
            }
            try {
                String algo = SerializationUtil.readString((DataStreamReader)reader, (int)8);
                if (algo == null) {
                    throw new IllegalArgumentException("key must have algorithm!");
                }
                key = SecretUtil.create(data, algo.intern());
            }
            finally {
                Bytes.clear((byte[])data);
            }
        }
        return key;
    }

    public static void write(DatagramWriter writer, SecretIvParameterSpec iv) {
        if (iv == null || SecretUtil.isDestroyed(iv)) {
            writer.write(0, 8);
        } else {
            writer.write(iv.size(), 8);
            iv.writeTo(writer);
        }
    }

    public static SecretIvParameterSpec readIv(DatagramReader reader) {
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            SecretIvParameterSpec iv = SecretUtil.createIv(data);
            Bytes.clear((byte[])data);
            return iv;
        }
        return null;
    }
}

