/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.views.ConfigurationWebContainerView;
import org.ops4j.pax.web.service.spi.util.WebContainerListener;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.views.PaxWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerManager
implements BundleListener,
ServiceTrackerCustomizer<WebContainer, ServiceReference<WebContainer>> {
    public static final Logger LOG = LoggerFactory.getLogger(WebContainerManager.class);
    private final BundleContext context;
    private final ServiceTracker<WebContainer, ServiceReference<WebContainer>> webContainerTracker;
    private final AtomicReference<ServiceReference<WebContainer>> currentWebContainerRef = new AtomicReference();
    private final WebContainerListener listener;
    private Executor pool;
    private final boolean synchronous;
    private final String threadName;
    private final Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> containers = new HashMap<ServiceReference<WebContainer>, Map<Bundle, WebContainer>>();

    public WebContainerManager(BundleContext context, WebContainerListener listener) {
        this(context, listener, null);
    }

    public WebContainerManager(BundleContext context, WebContainerListener listener, String threadName) {
        this.context = context;
        this.listener = listener;
        this.threadName = threadName;
        this.synchronous = threadName == null;
        this.pool = threadName != null ? this.localThreadExecutor() : Runnable::run;
        listener.setExecutor(this.pool);
        this.webContainerTracker = new ServiceTracker(context, WebContainer.class, (ServiceTrackerCustomizer)this);
    }

    private Executor localThreadExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            ThreadFactory tf = Executors.defaultThreadFactory();
            Thread thread = tf.newThread(r);
            thread.setName(this.threadName);
            return thread;
        });
    }

    public void initialize() {
        this.context.addBundleListener((BundleListener)this);
        this.webContainerTracker.open(false);
    }

    public void shutdown() {
        this.webContainerTracker.close();
        this.context.removeBundleListener((BundleListener)this);
        if (this.pool instanceof ExecutorService) {
            ((ExecutorService)this.pool).shutdown();
        }
        this.pool = null;
    }

    private void webContainerChanged(ServiceReference<WebContainer> newReference) {
        ServiceReference<WebContainer> previous = this.currentWebContainerRef.getAndSet(newReference);
        LOG.debug("WebContainer changed from {} to {}", previous, newReference);
        this.pool.execute(() -> {
            if (previous == newReference) {
                return;
            }
            String name = Thread.currentThread().getName();
            try {
                if (previous == null) {
                    Thread.currentThread().setName(this.threadName + " (add HttpService)");
                } else if (newReference == null) {
                    Thread.currentThread().setName(this.threadName + " (remove HttpService)");
                } else {
                    Thread.currentThread().setName(this.threadName + " (change HttpService)");
                }
                this.listener.webContainerChanged(previous, newReference);
            }
            finally {
                Thread.currentThread().setName(name);
            }
        });
    }

    public ServiceReference<WebContainer> currentWebContainerReference() {
        return this.currentWebContainerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PaxWebContainerView> T containerView(Bundle bundle, ServiceReference<WebContainer> ref, Class<T> viewClass) {
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            WebContainer webContainer = this.container(bundle, ref);
            if (webContainer != null) {
                return (T)webContainer.adapt(viewClass);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebContainer container(Bundle bundle, ServiceReference<WebContainer> ref) {
        BundleContext bundleContext;
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (ref == null || bundle == null) {
            return null;
        }
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            WebContainer webContainer;
            ConfigurationWebContainerView configView;
            WebContainer container;
            Map<Bundle, WebContainer> bundleContainers = this.containers.get(ref);
            if (bundleContainers != null && (container = bundleContainers.get(bundle)) != null) {
                configView = (ConfigurationWebContainerView)container.adapt(ConfigurationWebContainerView.class);
                if (configView != null && configView.isValid()) {
                    return container;
                }
                bundleContainers.remove(bundle);
            }
            if (bundleContext == null) {
                return null;
            }
            try {
                webContainer = (WebContainer)bundleContext.getService(ref);
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (webContainer == null) {
                return null;
            }
            configView = (ConfigurationWebContainerView)webContainer.adapt(ConfigurationWebContainerView.class);
            if (configView != null && configView.isValid()) {
                this.containers.computeIfAbsent(ref, r -> new HashMap()).put(bundle, webContainer);
                return webContainer;
            }
            return null;
        }
    }

    public WhiteboardWebContainerView whiteboardView(Bundle bundle) {
        return this.containerView(bundle, this.currentWebContainerRef.get(), WhiteboardWebContainerView.class);
    }

    public WhiteboardWebContainerView whiteboardView(Bundle bundle, ServiceReference<WebContainer> ref) {
        return this.containerView(bundle, ref, WhiteboardWebContainerView.class);
    }

    public void releaseContainer(Bundle bundle) {
        this.releaseContainer(bundle, this.currentWebContainerRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseContainer(Bundle bundle, ServiceReference<WebContainer> ref) {
        if (ref == null || bundle == null) {
            return;
        }
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            Map<Bundle, WebContainer> bundleContainers = this.containers.get(ref);
            if (bundleContainers != null) {
                WebContainer container = bundleContainers.remove(bundle);
                if (container != null) {
                    try {
                        BundleContext bundleContext = bundle.getBundleContext();
                        if (bundleContext != null) {
                            bundleContext.ungetService(ref);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (bundleContainers.isEmpty()) {
                    this.containers.remove(ref);
                }
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.pool.execute(() -> {
                String name = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(name + " (stop " + event.getBundle().getSymbolicName() + ")");
                    this.listener.bundleStopped(event.getBundle());
                }
                finally {
                    Thread.currentThread().setName(name);
                }
            });
        }
    }

    public ServiceReference<WebContainer> addingService(ServiceReference<WebContainer> reference) {
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (currentReference == null || currentReference.compareTo(reference) < 0) {
            this.webContainerChanged(reference);
        }
        return reference;
    }

    public void modifiedService(ServiceReference<WebContainer> reference, ServiceReference<WebContainer> service) {
        ServiceReference bestReference = this.webContainerTracker.getServiceReference();
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (bestReference != null && (currentReference == null || currentReference.compareTo((Object)bestReference) < 0)) {
            this.webContainerChanged((ServiceReference<WebContainer>)bestReference);
        } else if (currentReference != null) {
            this.webContainerChanged(null);
        }
    }

    public void removedService(ServiceReference<WebContainer> reference, ServiceReference<WebContainer> service) {
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (currentReference == null) {
            return;
        }
        ServiceReference bestReference = this.webContainerTracker.getServiceReference();
        this.webContainerChanged((ServiceReference<WebContainer>)bestReference);
    }
}

