/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

final class FileValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 2773328295435703361L;
    @NotNull
    private final AtomicLong sequentialCounter;
    private final boolean sequential;
    @NotNull
    private final String[] lines;
    @NotNull
    private final Random seedRandom;
    @NotNull
    private final ThreadLocal<Random> random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileValuePatternComponent(@NotNull String path, long seed, boolean sequential) throws IOException {
        this.sequential = sequential;
        this.sequentialCounter = new AtomicLong(0L);
        this.seedRandom = new Random(seed);
        this.random = new ThreadLocal();
        ArrayList<String> lineList = new ArrayList<String>(100);
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
        }
        if (lineList.isEmpty()) {
            throw new IOException(UtilityMessages.ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE.get());
        }
        this.lines = new String[lineList.size()];
        lineList.toArray(this.lines);
    }

    @Override
    void append(@NotNull StringBuilder buffer) {
        int index;
        if (this.sequential) {
            index = (int)(this.sequentialCounter.getAndIncrement() % (long)this.lines.length);
        } else {
            Random r = this.random.get();
            if (r == null) {
                r = new Random(this.seedRandom.nextLong());
                this.random.set(r);
            }
            index = r.nextInt(this.lines.length);
        }
        buffer.append(this.lines[index]);
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }
}

