from .. import Provider as BaseProvider

# Source: ONISEP
# https://www.data.gouv.fr/fr/datasets/r/462f1a98-6f37-4414-9e08-016b78cc4d08


class Provider(BaseProvider):
    jobs = [
        "BIM manager",
        "accessoiriste",
        "accompagnant éducatif et social éducative et sociale",
        "accompagnateur de tourisme équestre",
        "accompagnateur de voyages",
        "accompagnateur en moyenne montagne",
        "acheteur",
        "acheteur d'espaces publicitaires",
        "actuaire",
        "adjoint administratif administrative",
        "administrateur de base de données",
        "administrateur de biens",
        "administrateur de logiciels de laboratoire",
        "administrateur de mission humanitaire",
        "administrateur de spectacle",
        "administrateur judiciaire",
        "administrateur réseaux",
        "administrateur territorial",
        "affûteur",
        "agenceur de cuisines et salles de bains",
        "agent arboricole",
        "agent artistique",
        "agent d'escale",
        "agent d'exploitation de l'eau",
        "agent de constatation des douanes",
        "agent de développement des énergies renouvelables",
        "agent de développement local",
        "agent de développement touristique",
        "agent de propreté et d'hygiène",
        "agent de propreté urbaine",
        "agent de sécurité",
        "agent de sûreté ferroviaire",
        "agent de transit",
        "agent général générale d'assurances",
        "agent hydrothermal hydrothermale",
        "agent immobilier immobilière",
        "agriculteur",
        "agronome",
        "aide-chimiste",
        "aide-soignant",
        "ajusteur-monteur",
        "ambulancier",
        "analyste de crédit",
        "analyste financier",
        "anatomiste",
        "anesthésiste-réanimateur",
        "animalier de laboratoire",
        "animateur 2D et 3D",
        "animateur d'activités physiques et sportives pour tous",
        "animateur de bassin versant",
        "animateur de radio et de télévision",
        "animateur du patrimoine",
        "animateur nature nature",
        "animateur socioculturel socioculturelle",
        "antiquaire",
        "apiculteur",
        "aquaculteur",
        "architecte",
        "architecte d'intérieur",
        "architecte des systèmes d'information",
        "architecte naval",
        "architecte produit industriel",
        "architecte réseaux",
        "architecte web",
        "archiviste",
        "archéologue",
        "art-thérapeute",
        "artiste de cirque",
        "ascensoriste",
        "assistant commercial commerciale",
        "assistant de gestion en PME",
        "assistant de service social",
        "assistant dentaire",
        "assistant en architecture",
        "assistant en ressources humaines",
        "assistant en études de prix",
        "assistant maternel maternelle",
        "assistant réalisateur réalisatrice",
        "astrophysicien",
        "attaché commercial commerciale",
        "attaché d'administration",
        "attaché de presse",
        "attaché de recherche clinique (ARC)",
        "attaché territorial territoriale",
        "audioprothésiste",
        "auditeur externe",
        "auditeur interne",
        "auditeur qualité",
        "auteur-compositeur interprète interprète",
        "auxiliaire de puériculture",
        "auxiliaire spécialisé vétérinaire",
        "avocat",
        "aérodynamicien",
        "bactériologiste",
        "barman",
        "batelier",
        "bibliothécaire",
        "bijoutier-joaillier",
        "bio-informaticien",
        "biologiste en environnement",
        "biologiste médical",
        "biostatisticien",
        "botaniste",
        "bottier",
        "boucher",
        "boulanger",
        "brancardier",
        "brodeur",
        "bronzier",
        "cadreur",
        "caissier",
        "canalisateur",
        "carreleur",
        "carrossier",
        "cartographe",
        "chanteur",
        "charcutier-traiteur",
        "chargé de recherche en recrutement",
        "chargé d'affaires en génie climatique",
        "chargé d'affaires en génie mécanique",
        "chargé d'études en marketing",
        "chargé d'études en valorisation agricole des déchets",
        "chargé d'études média",
        "chargé d'études naturalistes",
        "chargé d'études ressources humaines",
        "chargé d'études économiques",
        "chargé de clientèle banque",
        "chargé de communication interne",
        "chargé de pharmacovigilance",
        "chargé de production",
        "chargé de projet événementiel",
        "chargé de recherche en acoustique musicale",
        "chargé de recherche et développement déchets",
        "chargé de référencement web",
        "chargé de valorisation de la recherche",
        "chargé de veille législative et réglementaire",
        "chargé des méthodes outils et qualité en informatique",
        "chargé des relations publiques",
        "chargé hygiène sécurité environnement (HSE)",
        "charpentier bois",
        "charpentier métallique",
        "chaudronnier",
        "chauffeur de taxi",
        "chef de projet packaging",
        "chef comptable",
        "chef d'exploitation d'usine d'incinération",
        "chef d'exploitation des remontées mécaniques",
        "chef de chantier",
        "chef de chantier en installations électriques",
        "chef de cultures légumières",
        "chef de fabrication des industries graphiques",
        "chef de mission humanitaire",
        "chef de produit marketing",
        "chef de produit technique en informatique",
        "chef de produit touristique",
        "chef de projet biodiversité",
        "chef de projet communication digitale",
        "chef de projet démantèlement nucléaire",
        "chef de projet informatique",
        "chef de projet multimédia",
        "chef de projet sites et sols pollués",
        "chef de projet web/mobile",
        "chef de projet éolien",
        "chef de publicité",
        "chef de rayon",
        "chef de station de traitement des eaux",
        "chef des ventes",
        "chef monteur monteuse",
        "chercheur en biologie",
        "chercheur en biologie du sport",
        "chercheur en chimie",
        "chercheur en physique",
        "chirurgien",
        "chirurgien-dentiste",
        "chocolatier-confiseur",
        "clerc d'huissier",
        "climatologue",
        "coffreur-boiseur",
        "cogniticien",
        "coiffeur",
        "collaborateur de notaire de notaire",
        "collecteur de fonds",
        "coloriste",
        "commercial export",
        "commercial à bord des trains",
        "commerçant en alimentation",
        "commissaire de police",
        "commissaire-priseur",
        "community manager",
        "comptable",
        "comédien",
        "concepteur de jeux vidéo",
        "concepteur de niveaux de jeu web",
        "concepteur designer packaging",
        "concepteur multimédia",
        "concepteur-rédacteur",
        "conducteur d'engins de travaux publics",
        "conducteur d'engins forestiers de récolte en entreprises de travaux forestiers",
        "conducteur de bus ou d'autocar",
        "conducteur de ligne de production alimentaire",
        "conducteur de machine onduleuse",
        "conducteur de machines agricoles",
        "conducteur de machines à imprimer",
        "conducteur de métro",
        "conducteur de train",
        "conducteur de travaux",
        "conducteur de travaux  agricoles",
        "conducteur opérateur opératrice de scierie",
        "conducteur routier routière",
        "conducteur de machines à papier",
        "conseiller agricole",
        "conseiller d'élevage",
        "conseiller en assurances",
        "conseiller en environnement",
        "conseiller en fusions-acquisitions",
        "conseiller en génétique",
        "conseiller en insertion sociale et professionnelle",
        "conseiller en séjour",
        "conseiller en voyages",
        "conseiller en économie sociale et familiale",
        "conseiller espace info-énergie",
        "conseiller principal d'éducation principale d'éducation",
        "conseiller pénitentiaire d'insertion et de probation",
        "conseiller sportif sportive en salle de remise en forme",
        "conservateur du patrimoine",
        "conservateur territorial de bibliothèques",
        "consignataire de navire",
        "constructeur de routes",
        "consultant",
        "consultant SaaS",
        "consultant en conduite de changement",
        "consultant en informatique décisionnelle",
        "consultant en management de l'innovation",
        "consultant en solutions intégrées",
        "consultant en systèmes d'information",
        "consultant en validation",
        "consultant green IT",
        "consultant informatique",
        "contremaître",
        "contrôleur aérien aérienne",
        "contrôleur de gestion",
        "contrôleur de performance",
        "contrôleur des douanes et droits indirects",
        "contrôleur technique automobile",
        "convoyeur de fonds",
        "coordonnateur d'études cliniques",
        "cordiste",
        "cordonnier",
        "correcteur",
        "costumier",
        "courtier",
        "couvreur",
        "credit manager",
        "critique d'art",
        "cryptologue",
        "cuisinier",
        "céramiste",
        "danseur",
        "data manager",
        "designer d'interaction",
        "designer graphique",
        "designer industriel industrielle",
        "designer sonore",
        "dessinateur de BD",
        "dessinateur en construction mécanique",
        "dessinateur-projeteur",
        "diagnostiqueur immobilier",
        "directeur artistique",
        "directeur d'accueil collectif de mineurs (ACM)",
        "directeur d'agence bancaire",
        "directeur d'hôpital",
        "directeur d'hôtel",
        "directeur d'office de tourisme",
        "directeur de création",
        "directeur de golf",
        "directeur de la photographie",
        "directeur de magasin à grande surface",
        "directeur de restaurant",
        "directeur des services pénitentiaires",
        "diététicien",
        "documentaliste",
        "domoticien",
        "déclarant en douane",
        "décolleteur",
        "décorateur",
        "démographe",
        "déménageur",
        "dépanneur en électroménager",
        "développeur d'applications mobiles",
        "développeur informatique",
        "développeur rural rurale humanitaire",
        "développeur économique",
        "employé d'élevage",
        "employé de chai",
        "employé de pressing",
        "employé de restaurant",
        "encadreur",
        "enquêteur privé privée",
        "enseignant d'art",
        "enseignant de la conduite automobile et de la sécurité routière",
        "enseignant humanitaire",
        "enseignant spécialisé spécialisée",
        "enseignant-chercheur",
        "entraîneur de chevaux",
        "entraîneur sportif sportive",
        "ergonome",
        "ergothérapeute",
        "esthéticien-cosméticien",
        "ethnologue",
        "expert bilan carbone",
        "expert automobile",
        "expert en assurances",
        "expert en sécurité informatique",
        "expert immobilier immobilier",
        "expert-comptable",
        "facteur",
        "facteur d'instruments",
        "façadier",
        "façonnier des industries graphiques",
        "femme de chambre",
        "ferronnier d'art",
        "fiscaliste",
        "fleuriste",
        "formateur d'adultes",
        "formateur en informatique",
        "formateur technique en agroéquipement",
        "formulateur",
        "garde (chasse, pêche, littoral, rivière, parcs nationaux)",
        "garde à cheval",
        "gardien de la paix",
        "gardien de police municipale",
        "garçon de café",
        "gendarme",
        "gestionnaire actif/passif",
        "gestionnaire de contrats d'assurance",
        "gestionnaire de contrats informatiques",
        "gestionnaire de données cliniques",
        "gestionnaire de parc micro-informatique",
        "gestionnaire de patrimoine",
        "glaciologue",
        "gouvernant",
        "greffier",
        "grutier",
        "guichetier",
        "guide de haute montagne",
        "guide-conférencier",
        "généalogiste",
        "généticien",
        "géochimiste",
        "géographe",
        "géologue",
        "géologue minier",
        "géologue modélisateur",
        "géomaticien",
        "géomètre-topographe",
        "géophysicien",
        "géotechnicien",
        "géothermicien",
        "gérant de portefeuille",
        "gérant de restauration collective",
        "halieute",
        "histologiste",
        "horloger",
        "horticulteur",
        "hot liner",
        "huissier de justice",
        "hydraulicien",
        "hydrogéologue",
        "hydrologue",
        "hôte d'accueil",
        "hôtesse de l'air",
        "iconographe",
        "illustrateur",
        "infirmier",
        "infirmier humanitaire",
        "informaticien industriel industrielle",
        "ingénieur RD en énergies renouvelables",
        "ingénieur analogicien analogicienne",
        "ingénieur analyste de l'air",
        "ingénieur aromaticien aromaticienne",
        "ingénieur biomédical biomédicale",
        "ingénieur brevets",
        "ingénieur calcul",
        "ingénieur chimiste",
        "ingénieur chimiste en développement analytique",
        "ingénieur cloud computing",
        "ingénieur combustion et brûleurs",
        "ingénieur concepteur conceptrice en mécanique",
        "ingénieur d'affaires en génie électrique",
        "ingénieur d'application",
        "ingénieur d'études en sûreté nucléaire",
        "ingénieur de la police technique et scientifique",
        "ingénieur de maintenance industrielle",
        "ingénieur de recherche (papiers cartons)",
        "ingénieur de recherche clinique et épidémiologique",
        "ingénieur du BTP",
        "ingénieur du son",
        "ingénieur efficacité énergétique du bâtiment",
        "ingénieur en acoustique",
        "ingénieur en automatismes",
        "ingénieur en aéronautique",
        "ingénieur en caractérisation des matériaux",
        "ingénieur en chef territorial",
        "ingénieur en construction automobile",
        "ingénieur en construction navale",
        "ingénieur en fonderie",
        "ingénieur en génie climatique",
        "ingénieur en imagerie médicale",
        "ingénieur en mécanique",
        "ingénieur en métrologie",
        "ingénieur en production et expérimentations végétales",
        "ingénieur en électronique numérique",
        "ingénieur en énergie solaire",
        "ingénieur environnement",
        "ingénieur environnement et risques industriels",
        "ingénieur essais",
        "ingénieur fluides, énergies, réseaux, environnement",
        "ingénieur forage",
        "ingénieur forestier forestière",
        "ingénieur frigoriste",
        "ingénieur gaz",
        "ingénieur hydrogéomorphologue",
        "ingénieur hydroécologue",
        "ingénieur intégration satellite",
        "ingénieur logiciel",
        "ingénieur logistique",
        "ingénieur maintenance aéronautique",
        "ingénieur mathématicien",
        "ingénieur matériaux",
        "ingénieur métallurgiste",
        "ingénieur méthodes mécaniques",
        "ingénieur nucléaire",
        "ingénieur opticien opticienne",
        "ingénieur papetier papetière",
        "ingénieur plasturgiste",
        "ingénieur process aval",
        "ingénieur procédés en chimie",
        "ingénieur production dans les biotechnologies",
        "ingénieur production en aéronautique",
        "ingénieur production en mécanique",
        "ingénieur pétrolier pétrolière",
        "ingénieur qualité moteur",
        "ingénieur radioprotection",
        "ingénieur recherche et développement (R&amp;D) en agroéquipement",
        "ingénieur recherche et développement en agroalimentaire",
        "ingénieur réservoir",
        "ingénieur structures",
        "ingénieur support",
        "ingénieur système",
        "ingénieur systèmes embarqués",
        "ingénieur technico-commercial technico-commerciale",
        "ingénieur technico-commercial technico-commerciale en chimie",
        "ingénieur technico-commercial technico-commerciale en informatique",
        "ingénieur technico-commercial technico-commerciale en électronique",
        "ingénieur textile",
        "ingénieur traitement de l'image",
        "ingénieur télécoms et réseaux",
        "ingénieur écoconcepteur écoconceptrice",
        "ingénieur électricien",
        "ingénieur électronicien électronicienne",
        "ingénieur électronicien électronicienne des systèmes de la sécurité aérienne (IESSA)",
        "ingénieur études et développement en logiciels de simulation",
        "inspecteur de banque",
        "inspecteur des douanes, des finances publiques ou du travail",
        "inspecteur du permis de conduire et de la sécurité routière",
        "installateur en télécoms",
        "inséminateur",
        "intégrateur web",
        "journaliste",
        "journaliste reporter d'images",
        "juge d'instruction",
        "juge des contentieux de la protection",
        "juge des enfants",
        "juriste d'entreprise",
        "juriste droit de l'environnement",
        "juriste en droit social",
        "juriste en propriété intellectuelle",
        "lad-jockey, lad-driver",
        "libraire",
        "linguiste",
        "machiniste-constructeur ou plateau",
        "magasinier cariste",
        "magistrat",
        "manager de risques",
        "mandataire judiciaire",
        "manipulateur en électroradiologie médicale",
        "maquettiste",
        "maquilleur artistique",
        "maraîcher",
        "marchandiseur",
        "maroquinier",
        "maréchal-ferrant",
        "masseur",
        "matelot de la Marine Nationale",
        "matelot de la marine marchande",
        "matelot à la pêche",
        "maçon",
        "maître d'hôtel",
        "maître-chien",
        "menuisier",
        "metteur en scène",
        "microbiologiste",
        "microtechnicien",
        "militaire du rang de l'armée de terre",
        "militaire technicien de l'air (MTA)",
        "miroitier",
        "mixeur son",
        "modiste",
        "modéliste",
        "moniteur d'activités équestres",
        "moniteur de ski",
        "moniteur-éducateur",
        "monteur en installations thermiques et climatiques",
        "monteur en réseaux de distribution électrique",
        "monteur-câbleur",
        "mouleur-noyauteur",
        "musicien",
        "mécanicien bateaux",
        "mécanicien d'entretien d'avion",
        "mécanicien et technicien",
        "mécanicien marine navigant",
        "mécanicien-outilleur",
        "mécanicien-réparateur en matériel agricole",
        "mécatronicien",
        "médecin de secours en montagne",
        "médecin généraliste",
        "médecin humanitaire",
        "médecin spécialiste",
        "médiateur familial familiale",
        "médiateur scientifique",
        "météorologiste",
        "neurobiologiste",
        "nivoculteur",
        "notaire",
        "océanologue",
        "oenologue",
        "officier de gendarmerie",
        "officier de l'armée de l'air",
        "officier de l'armée de terre",
        "officier de la Marine nationale",
        "officier de la marine marchande",
        "officier de police",
        "officier marinier marinière",
        "opticien-lunetier",
        "optronicien",
        "opérateur de fabrication de produits alimentaires",
        "opérateur de raffinerie",
        "opérateur en traitement des matériaux",
        "opérateur prépresse",
        "opérateur sur machine à commande numérique",
        "orfèvre",
        "orthodontiste",
        "orthophoniste",
        "orthoprothésiste",
        "orthoptiste",
        "ostéopathe",
        "ouvrier agricole",
        "ouvrier forestier forestière",
        "ouvrier paysagiste",
        "ouvrier plasturgiste",
        "palefrenier",
        "paléontologue",
        "parfumeur",
        "patron pêcheur",
        "paysagiste",
        "peintre en bâtiment",
        "pharmacien",
        "pharmacien dans l'industrie",
        "photographe",
        "physicien médical médicale",
        "pilote d'hélicoptère",
        "pilote de ligne",
        "pilote de ligne automatisée (chimie - agroalimentaire - industrie pharmaceutique)",
        "pisteur secouriste",
        "plombier",
        "plâtrier",
        "podo-orthésiste",
        "poissonnier",
        "professeur d'éducation physique et sportive (EPS)",
        "professeur dans l'enseignement agricole",
        "professeur de collège et de lycée",
        "professeur de lycée professionnel",
        "professeur de mathématiques ou de physique-chimie",
        "professeur de musique et de danse",
        "professeur des écoles des écoles",
        "professeur en activité physique adaptée",
        "professeur-documentaliste",
        "programmiste",
        "projectionniste",
        "prothésiste dentaire",
        "prototypiste en matériaux souples",
        "préparateur en pharmacie",
        "psychanalyste",
        "psychologue",
        "psychologue de l'Éducation nationale spécialité éducation, développement et apprentissages",
        "psychologue de l'éducation nationale spécialité éducation, développement et conseil en"
        + " orientation scolaire et professionnelle",
        "psychomotricien",
        "puériculteur",
        "pâtissier",
        "pédiatre",
        "pédicure-podologue",
        "pédologue",
        "relieur-doreur",
        "reporter-photographe",
        "responsable achats en chimie",
        "responsable approvisionnement",
        "responsable assurance qualité",
        "responsable biométrie",
        "responsable d'élevage agricole",
        "responsable de fabrication en chimie",
        "responsable de formation",
        "responsable de la collecte des déchets ménagers",
        "responsable de la promotion des ventes",
        "responsable de laboratoire de contrôle en biologie",
        "responsable de laboratoire de contrôle en chimie",
        "responsable de laboratoire de recherche",
        "responsable de plate-forme biotechnologique",
        "responsable de production alimentaire",
        "responsable de projets culturels",
        "responsable de rémunération",
        "responsable de réseau d'assainissement",
        "responsable de réseau eau potable",
        "responsable de scierie",
        "responsable de site de traitement des déchets",
        "responsable des ouvrages hydroélectriques",
        "responsable des produits structurés actions",
        "responsable des ressources humaines",
        "responsable du back office",
        "responsable du recrutement",
        "responsable du service après-vente",
        "responsable du soutien logistique intégré",
        "responsable e-CRM",
        "responsable qualité en agroalimentaire",
        "restaurateur d'oeuvres d'art",
        "roboticien",
        "rudologue",
        "réceptionniste",
        "rédacteur en chef",
        "rédacteur médical médicale",
        "rédacteur on line",
        "rédacteur territorial territoriale",
        "réflexologue",
        "régisseur de spectacles",
        "régisseur général générale cinéma",
        "régisseur lumière",
        "régleur",
        "sage-femme",
        "salesman",
        "sapeur-pompier",
        "scripte",
        "sculpteur sur bois",
        "scénariste",
        "secrétaire",
        "secrétaire administratif",
        "secrétaire d'édition",
        "secrétaire de rédaction",
        "secrétaire des affaires étrangères",
        "secrétaire juridique",
        "secrétaire médical",
        "sellier",
        "serrurier dépanneur dépanneuse",
        "serrurier-métallier",
        "sociologue",
        "soigneur d'animaux",
        "solier-moquettiste",
        "sommelier",
        "soudeur",
        "souffleur de verre",
        "sous-officier de l'armée de l'air",
        "sous-officier de l'armée de terre",
        "souscripteur",
        "sportif de haut niveau",
        "spécialiste de l'accessibilité numérique",
        "spécialiste des affaires réglementaires en chimie",
        "staffeur-ornemaniste",
        "statisticien",
        "statisticien en analyse sensorielle",
        "statisticien en géomarketing",
        "statisticien industriel industrielle",
        "styliste",
        "substitut du procureur",
        "surveillant de centre pénitentiaire",
        "syndic de copropriété",
        "sérigraphe",
        "tailleur de pierre",
        "tailleur-couturier",
        "tapissier d'ameublement",
        "technicien automobile",
        "technicien biologiste",
        "technicien chimiste",
        "technicien céramiste",
        "technicien d'analyses biomédicales",
        "technicien d'essais",
        "technicien d'exploitation de l'eau",
        "technicien d'exploitation du réseau gaz",
        "technicien d'intervention clientèle gaz",
        "technicien de contrôle",
        "technicien de fabrication de mobilier et de menuiserie",
        "technicien de forge",
        "technicien de l'intervention sociale et familiale",
        "technicien de la circulation ferroviaire SNCF",
        "technicien de maintenance en génie climatique",
        "technicien de maintenance en informatique",
        "technicien de maintenance industrielle",
        "technicien de police technique et scientifique",
        "technicien des industries du verre",
        "technicien démonstrateur démonstratrice en matériel agricole",
        "technicien en automatismes",
        "technicien en engins de travaux publics",
        "technicien en lignes haute tension",
        "technicien en métrologie",
        "technicien en optique de précision",
        "technicien en traitement des déchets",
        "technicien en traitement des matériaux",
        "technicien forestier forestière",
        "technicien logistique",
        "technicien packaging",
        "technicien paysagiste",
        "technicien plasturgiste",
        "technicien prototypiste en agroéquipement",
        "technicien pétrolier pétrolière",
        "technicien qualité",
        "technicien radioprotection",
        "technicien réalisateur réalisatrice radio",
        "technicien thermicien thermicienne",
        "technicien télécoms et réseaux",
        "technicien électronicien électronicienne",
        "technicien électrotechnicien électrotechnicienne",
        "technico-commercial en agroalimentaire",
        "teinturier blanchisseur",
        "testeur",
        "toiletteur d'animaux",
        "tonnelier",
        "trader",
        "traducteur technique",
        "traducteur-interprète",
        "traffic manager",
        "télévendeur",
        "urbaniste",
        "veilleur stratégique",
        "vendeur conseil caviste",
        "vendeur en animalerie",
        "vendeur en magasin",
        "vendeur en micro-informatique et multimédia",
        "vendeur-conseil en matériel agricole",
        "vendeur-magasinier en fournitures automobiles",
        "verrier au chalumeau",
        "visiteur médical médicale",
        "viticulteur",
        "vitrailliste",
        "volcanologue",
        "vétérinaire",
        "web-ergonome",
        "webdesigner",
        "webmestre",
        "yield manager",
        "zoologiste",
        "ébéniste",
        "éclairagiste",
        "économe de flux",
        "économiste de la construction",
        "économètre statisticien",
        "écrivain",
        "éditeur",
        "éducateur canin canine",
        "éducateur de jeunes enfants",
        "éducateur de la protection judiciaire de la jeunesse (PJJ)",
        "éducateur sportif sportive",
        "éducateur sportif sportive des activités aquatiques et de la natation",
        "éducateur spécialisé spécialisée",
        "éducateur technique spécialisé technique spécialisée",
        "élagueur",
        "électricien installateur installatrice",
        "électromécanicien",
        "électromécanicien en remontées mécaniques",
        "électronicien automobile",
        "énergéticien",
        "étalagiste",
        "étanchéiste",
    ]

    jobs_female = [
        "BIM manageuse",
        "accessoiriste",
        "accompagnante éducative et sociale",
        "accompagnatrice de tourisme équestre",
        "accompagnatrice de voyages",
        "accompagnatrice en moyenne montagne",
        "acheteuse",
        "acheteuse d'espaces publicitaires",
        "actuaire",
        "adjointe administrative",
        "administratrice de base de données",
        "administratrice de biens",
        "administratrice de logiciels de laboratoire",
        "administratrice de mission humanitaire",
        "administratrice de spectacle",
        "administratrice judiciaire",
        "administratrice réseaux",
        "administratrice territoriale",
        "affûteuse",
        "agenceuse de cuisines et salles de bains",
        "agente arboricole",
        "agente artistique",
        "agente d'escale",
        "agente d'exploitation de l'eau",
        "agente de constatation des douanes",
        "agente de développement des énergies renouvelables",
        "agente de développement local",
        "agente de développement touristique",
        "agente de propreté et d'hygiène",
        "agente de propreté urbaine",
        "agente de sécurité",
        "agente de sûreté ferroviaire",
        "agente de transit",
        "agente générale d’assurances",
        "agente hydrothermale",
        "agente immobilière",
        "agricultrice",
        "agronome",
        "aide-chimiste",
        "aide-soignante",
        "ajusteuse-monteuse",
        "ambulancière",
        "analyste de crédit",
        "analyste financière",
        "anatomiste",
        "anesthésiste-réanimatrice",
        "animalière de laboratoire",
        "animatrice 2D et 3D",
        "animatrice d'activités physiques et sportives pour tous",
        "animatrice de bassin versant",
        "animatrice de radio et de télévision",
        "animatrice du patrimoine",
        "animatrice nature",
        "animatrice socioculturelle",
        "antiquaire",
        "apicultrice",
        "aquacultrice",
        "architecte",
        "architecte d’intérieur",
        "architecte des systèmes d'information",
        "architecte navale",
        "architecte produit industriel",
        "architecte réseaux",
        "architecte web",
        "archiviste",
        "archéologue",
        "art-thérapeute",
        "artiste de cirque",
        "ascensoriste",
        "assistante commerciale",
        "assistante de gestion en PME",
        "assistante de service social",
        "assistante dentaire",
        "assistante en architecture",
        "assistante en ressources humaines",
        "assistante en études de prix",
        "assistante maternelle",
        "assistante réalisatrice",
        "astrophysicienne",
        "attachée commerciale",
        "attachée d’administration",
        "attachée de presse",
        "attachée de recherche clinique",
        "attachée territoriale",
        "audioprothésiste",
        "auditrice externe",
        "auditrice interne",
        "auditrice qualité",
        "autrice-compositrice-interprète",
        "auxiliaire de puériculture",
        "auxiliaire spécialisée vétérinaire",
        "avocate",
        "aérodynamicienne",
        "bactériologiste",
        "barmaid",
        "batelière",
        "bibliothécaire",
        "bijoutière-joaillière",
        "bio-informaticienne",
        "biologiste en environnement",
        "biologiste médicale",
        "biostatisticienne",
        "botaniste",
        "bottière",
        "bouchère",
        "boulangère",
        "brancardière",
        "brodeuse",
        "bronzière",
        "cadreuse",
        "caissière",
        "canalisatrice",
        "carreleuse",
        "carrossière",
        "cartographe",
        "chanteuse",
        "charcutière-traiteuse",
        "chargée de recherche en recrutement",
        "chargée d'affaires en génie climatique",
        "chargée d'affaires en génie mécanique",
        "chargée d’études en marketing",
        "chargée d’études en valorisation agricole des déchets",
        "chargée d’études média",
        "chargée d’études naturalistes",
        "chargée d’études ressources humaines",
        "chargée d’études économiques",
        "chargée de clientèle banque",
        "chargée de communication interne",
        "chargée de pharmacovigilance",
        "chargée de production",
        "chargée de projet événementiel",
        "chargée de recherche en acoustique musicale",
        "chargée de recherche et développement déchets",
        "chargée de référencement web",
        "chargée de valorisation de la recherche",
        "chargée de veille législative et réglementaire",
        "chargée des méthodes outils et qualité en informatique",
        "chargée des relations publiques",
        "chargée hygiène sécurité environnement (HSE)",
        "charpentière bois",
        "charpentière métallique",
        "chaudronnière",
        "chauffeuse de taxi",
        "cheffe de projet packaging",
        "cheffe comptable",
        "cheffe d’exploitation d’usine d’incinération",
        "cheffe d’exploitation des remontées mécaniques",
        "cheffe de chantier",
        "cheffe de chantier en installations électriques",
        "cheffe de cultures légumières",
        "cheffe de fabrication des industries graphiques",
        "cheffe de mission humanitaire",
        "cheffe de produit marketing",
        "cheffe de produit technique en informatique",
        "cheffe de produit touristique",
        "cheffe de projet biodiversité",
        "cheffe de projet communication digitale",
        "cheffe de projet démantèlement nucléaire",
        "cheffe de projet informatique",
        "cheffe de projet multimédia",
        "cheffe de projet sites et sols pollués",
        "cheffe de projet web/mobile",
        "cheffe de projet éolien",
        "cheffe de publicité",
        "cheffe de rayon",
        "cheffe de station de traitement des eaux",
        "cheffe des ventes",
        "cheffe monteuse",
        "chercheuse en biologie",
        "chercheuse en biologie du sport",
        "chercheuse en chimie",
        "chercheuse en physique",
        "chirurgienne",
        "chirurgienne-dentiste",
        "chocolatière-confiseuse",
        "clerc d’huissier (clercque)",
        "climatologue",
        "coffreuse-boiseuse",
        "cogniticienne",
        "coiffeuse",
        "collaboratrice de notaire",
        "collectrice de fonds",
        "coloriste",
        "commerciale export",
        "commerciale à bord des trains",
        "commerçante en alimentation",
        "commissaire de police",
        "commissaire-priseuse",
        "community manageuse",
        "comptable",
        "comédienne",
        "conceptrice de jeux vidéo",
        "conceptrice de niveaux de jeu web",
        "conceptrice designer packaging",
        "conceptrice multimédia",
        "conceptrice-rédactrice",
        "conductrice d'engins de travaux publics",
        "conductrice d'engins forestiers de récolte",
        "conductrice de bus ou d'autocar",
        "conductrice de ligne de production alimentaire",
        "conductrice de machine onduleuse",
        "conductrice de machines agricoles",
        "conductrice de machines à imprimer",
        "conductrice de métro",
        "conductrice de train",
        "conductrice de travaux",
        "conductrice de machines à papier",
        "conseillère agricole",
        "conseillère d’élevage",
        "conseillère en assurances",
        "conseillère en environnement",
        "conseillère en fusions-acquisitions",
        "conseillère en génétique",
        "conseillère en insertion sociale et professionnelle",
        "conseillère en séjour",
        "conseillère en voyages",
        "conseillère en économie sociale et familiale",
        "conseillère espace info-énergie",
        "conseillère principale d’éducation",
        "conseillère pénitentiaire d’insertion et de probation",
        "conseillère sportive en salle de remise en forme",
        "conservatrice du patrimoine",
        "conservatrice territoriale de bibliothèques",
        "consignataire de navire",
        "constructrice de routes",
        "consultante",
        "consultante SaaS",
        "consultante en conduite du changement",
        "consultante en informatique décisionnelle",
        "consultante en management de l’innovation",
        "consultante en solutions intégrées",
        "consultante en systèmes d'information",
        "consultante en validation",
        "consultante green IT",
        "consultante informatique",
        "contremaîtresse",
        "contrôleuse aérienne",
        "contrôleuse de gestion",
        "contrôleuse de performance",
        "contrôleuse des douanes et droits indirects",
        "contrôleuse technique automobile",
        "convoyeuse de fonds",
        "coordonnatrice d’études cliniques",
        "cordiste",
        "cordonnière",
        "correctrice",
        "costumière",
        "courtière",
        "couvreuse",
        "credit manageuse",
        "critique d’art",
        "cryptologue",
        "cuisinière",
        "céramiste",
        "danseuse",
        "data manageuse",
        "designeuse d’interaction",
        "designeuse graphique",
        "designeuse industrielle",
        "designeuse sonore",
        "dessinatrice de BD",
        "dessinatrice en construction mécanique",
        "dessinatrice-projeteuse",
        "diagnostiqueuse immobilière",
        "directrice artistique",
        "directrice d’accueil collectif de mineures (ACM)",
        "directrice d’agence bancaire",
        "directrice d’hôpital",
        "directrice d’hôtel",
        "directrice d’office de tourisme",
        "directrice de création",
        "directrice de golf",
        "directrice de la photographie",
        "directrice de magasin à grande surface",
        "directrice de restaurant",
        "directrice des services pénitentiaires",
        "diététicienne",
        "documentaliste",
        "domoticienne",
        "déclarante en douane",
        "décolleteuse",
        "décoratrice",
        "démographe",
        "déménageuse",
        "dépanneuse en électroménager",
        "développeuse d’applications mobiles",
        "développeuse informatique",
        "développeuse rurale humanitaire",
        "développeuse économique",
        "employée d’élevage",
        "employée de chai",
        "employée de pressing",
        "employée de restaurant",
        "encadreuse",
        "enquêtrice privée",
        "enseignante d’art",
        "enseignante de la conduite automobile et de la sécurité routière",
        "enseignante humanitaire",
        "enseignante spécialisée",
        "enseignante-chercheuse",
        "entraîneuse de chevaux",
        "entraîneuse sportive",
        "ergonome",
        "ergothérapeute",
        "esthéticienne-cosméticienne",
        "ethnologue",
        "experte bilan carbone",
        "experte automobile",
        "experte en assurances",
        "experte en sécurité informatique",
        "experte immobilière",
        "experte-comptable",
        "factrice",
        "factrice d’instruments",
        "façadière",
        "façonnière des industries graphiques",
        "femme de chambre",
        "ferronnière d’art",
        "fiscaliste",
        "fleuriste",
        "formatrice d’adultes",
        "formatrice en informatique",
        "formatrice technique en agroéquipement",
        "formulatrice",
        "garde-chasse, pêche, littoral, rivière, parcs nationaux",
        "garde à cheval",
        "gardienne de la paix",
        "gardienne de police municipale",
        "serveuse de café",
        "gendarmette",
        "gestionnaire actif/passif",
        "gestionnaire de contrats d’assurance",
        "gestionnaire de contrats informatiques",
        "gestionnaire de données cliniques",
        "gestionnaire de parc micro-informatique",
        "gestionnaire de patrimoine",
        "glaciologue",
        "gouvernante",
        "greffière",
        "grutière",
        "guichetière",
        "guide de haute montagne",
        "guide-conférencière",
        "généalogiste",
        "généticienne",
        "géochimiste",
        "géographe",
        "géologue",
        "géologue minière",
        "géologue modélisatrice",
        "géomaticienne",
        "géomètre-topographe",
        "géophysicienne",
        "géotechnicienne",
        "géothermicienne",
        "gérante de portefeuille",
        "gérante de restauration collective",
        "halieute",
        "histologiste",
        "horlogère",
        "horticultrice",
        "hotlineuse",
        "huissière de justice",
        "hydraulicienne",
        "hydrogéologue",
        "hydrologue",
        "hôtesse d’accueil",
        "hôtesse de l’air",
        "iconographe",
        "illustratrice",
        "infirmière",
        "infirmière humanitaire",
        "informaticienne industrielle",
        "ingénieure R&D en énergies renouvelables",
        "ingénieure analogicienne",
        "ingénieure analyste de l’air",
        "ingénieure aromaticienne",
        "ingénieure biomédicale",
        "ingénieure brevets",
        "ingénieure calcul",
        "ingénieure chimiste",
        "ingénieure chimiste en développement analytique",
        "ingénieure cloud computing",
        "ingénieure combustion et brûleurs",
        "ingénieure conceptrice en mécanique",
        "ingénieure d’affaires en génie électrique",
        "ingénieure d’application",
        "ingénieure d’études en sûreté nucléaire",
        "ingénieure de la police technique et scientifique",
        "ingénieure de maintenance industrielle",
        "ingénieure de recherche (papiers cartons)",
        "ingénieure de recherche clinique et épidémiologique",
        "ingénieure du BTP",
        "ingénieure du son",
        "ingénieure efficacité énergétique du bâtiment",
        "ingénieure en acoustique",
        "ingénieure en automatismes",
        "ingénieure en aéronautique",
        "ingénieure en caractérisation des matériaux",
        "ingénieure en chef territoriale",
        "ingénieure en construction automobile",
        "ingénieure en construction navale",
        "ingénieure en fonderie",
        "ingénieure en génie climatique",
        "ingénieure en imagerie médicale",
        "ingénieure en mécanique",
        "ingénieure en métrologie",
        "ingénieure en production et expérimentations végétales",
        "ingénieure en électronique numérique",
        "ingénieure en énergie solaire",
        "ingénieure environnement",
        "ingénieure environnement et risques industriels",
        "ingénieure essais",
        "ingénieure fluides, énergies, réseaux, environnement",
        "ingénieure forage",
        "ingénieure forestière",
        "ingénieure frigoriste",
        "ingénieure gaz",
        "ingénieure hydrogéomorphologue",
        "ingénieure hydroécologue",
        "ingénieure intégration satellite",
        "ingénieure logicielle",
        "ingénieure logistique",
        "ingénieure maintenance aéronautique",
        "ingénieure mathématicienne",
        "ingénieure matériaux",
        "ingénieure métallurgiste",
        "ingénieure méthodes mécaniques",
        "ingénieure nucléaire",
        "ingénieure opticienne",
        "ingénieure papetière",
        "ingénieure plasturgiste",
        "ingénieure process aval",
        "ingénieure procédés en chimie",
        "ingénieure production dans les biotechnologies",
        "ingénieure production en aéronautique",
        "ingénieure production en mécanique",
        "ingénieure pétrolière",
        "ingénieure qualité moteur",
        "ingénieure radioprotection",
        "ingénieure recherche et développement en agroéquipement",
        "ingénieure recherche et développement en agroalimentaire",
        "ingénieure réservoir",
        "ingénieure structures",
        "ingénieure support",
        "ingénieure système",
        "ingénieure systèmes embarqués",
        "ingénieure technico-commerciale",
        "ingénieure technico-commerciale en chimie",
        "ingénieure technico-commerciale en informatique",
        "ingénieure technico-commerciale en électronique",
        "ingénieure textile",
        "ingénieure traitement de l’image",
        "ingénieure télécoms et réseaux",
        "ingénieure écoconceptrice",
        "ingénieure électricienne",
        "ingénieure électronicienne",
        "ingénieure électronicienne des systèmes de la sécurité aérienne",
        "ingénieure études et développement en logiciels de simulation",
        "inspectrice de banque",
        "inspectrice des douanes, des finances publiques ou du travail",
        "inspectrice du permis de conduire et de la sécurité routière",
        "installatrice en télécoms",
        "inséminatrice",
        "intégratrice web",
        "journaliste",
        "journaliste reporter d’images",
        "juge d’instruction",
        "juge des contentieux de la protection",
        "juge des enfants",
        "juriste d’entreprise",
        "juriste en droit de l’environnement",
        "juriste en droit social",
        "juriste en propriété intellectuelle",
        "lad-jockette, lad-drivereuse",
        "libraire",
        "machiniste-constructrice décor",
        "magasinière-cariste",
        "magistrate",
        "mairesse",
        "maîtresse d’hôtel",
        "maîtresse de chai",
        "maîtresse de conférences",
        "maîtresse d’œuvre",
        "maîtresse nageuse sauveteuse",
        "maîtresse de port",
        "manageuse",
        "manageuse de communauté",
        "manageuse de projet industriel",
        "manageuse des ressources humaines",
        "manipulatrice en électroradiologie médicale",
        "mannequin",
        "maquettiste",
        "maquilleuse professionnelle",
        "marbrière du bâtiment et de la décoration",
        "marchande de biens",
        "maréchale-ferrante",
        "marine marchande (officière, cheffe mécanicienne, etc.)",
        "marionnettiste",
        "maroquinière",
        "masseuse-kinésithérapeute",
        "matelote",
        "mathématicienne",
        "mécanicienne automobile",
        "mécanicienne d’entretien industriel",
        "mécanicienne de maintenance aéronautique",
        "mécanicienne de précision",
        "mécanicienne réparatrice de cycles",
        "mécanicienne soudeuse",
        "médiatrice culturelle",
        "médiatrice familiale",
        "médecin",
        "médecin anesthésiste-réanimatrice",
        "médecin biologiste",
        "médecin du travail",
        "médecin généraliste",
        "médecin légiste",
        "médecin nutritionniste",
        "médecin urgentiste",
        "mélanographe",
        "menuisière",
        "menuisière-agenceuse",
        "merchandiseuse",
        "météorologue",
        "metteuse en scène",
        "metteuse en plis",
        "meunière",
        "militaire",
        "minière",
        "mixeuse son",
        "modéliste",
        "modéliste industriel textile",
        "monitrice auto-école",
        "monitrice de ski",
        "monitrice d’équitation",
        "monitrice-éducatrice",
        "monteuse de réseaux électriques",
        "monteuse en installations thermiques",
        "monteuse-câbleuse",
        "mosaïste",
        "mouleur-noyauteuse",
        "mécène",
        "musicienne",
        "médiathécaire",
        "naturopathe",
        "navigatrice",
        "neuropsychologue",
        "notaire",
        "numéricienne",
        "nutritionniste",
        "océanographe",
        "opératrice de fabrication agroalimentaire",
        "opératrice de laboratoire d’analyses médicales",
        "opératrice de maintenance industrielle",
        "opératrice de production chimique",
        "opératrice de saisie",
        "opératrice en électronique",
        "opératrice en télésurveillance",
        "opératrice projectionniste de cinéma",
        "opticienne-lunetière",
        "optométriste",
        "orfèvre",
        "orthophoniste",
        "orthoptiste",
        "ostéopathe",
        "ouvrière agricole",
        "ouvrière paysagiste",
        "paléontologue",
        "paludière",
        "paysagiste conceptrice",
        "peintre en bâtiment",
        "pépiniériste",
        "perceuse-fraiseuse",
        "perlière d’art",
        "personnelle navigante commerciale (PNC)",
        "pharmacienne",
        "pharmacienne hospitalière",
        "philosophe",
        "photographe",
        "photographe animalière",
        "photographe de presse",
        "phycologue",
        "physicienne",
        "physicienne médicale",
        "pilote d’hélicoptère",
        "pilote de ligne",
        "pilote de navire (lamaneuse, capitaine, etc.)",
        "pionnière (assistante d’éducation)",
        "piscicultrice",
        "pisteuse secouriste",
        "plâtrière-plaquiste",
        "plombière",
        "plâtrière",
        "poissonnière",
        "policière scientifique",
        "polisseuse sur verre",
        "politologue",
        "pompiste",
        "pompière professionnelle",
        "ponceuse sur métaux",
        "porteuse funéraire",
        "poseuse de revêtements de sols et murs",
        "postière",
        "potier-céramiste",
        "préparatrice en pharmacie",
        "préparatrice de commandes",
        "préparatrice physique",
        "présentatrice de télévision",
        "présidente-directrice générale (PDG)",
        "professeure d’anglais",
        "professeure d’éducation physique et sportive",
        "professeure documentaliste",
        "professeure des écoles",
        "professeure en lycée professionnel",
        "professeure agrégée",
        "professeure de danse",
        "professeure de musique",
        "professeure de yoga",
        "professeure-chercheuse",
        "programmiste",
        "programmeuse informatique",
        "programmeuse web",
        "projeteuse industrielle",
        "projeteuse en BTP",
        "promoteuse immobilière",
        "prothésiste dentaire",
        "prothésiste ongulaire",
        "prothésiste orthésiste",
        "psychologue",
        "psychologue clinicienne",
        "psychanalyste",
        "psychomotricienne",
        "puéricultrice",
        "paysanne",
        "peintre-décoratrice",
        "qualiticienne",
        "quantiticienne",
        "quartrière (industrie navale)",
        "rabbine",
        "radiologue",
        "ramoneuse",
        "rédactrice",
        "rédactrice de documentation technique",
        "rédactrice en chef",
        "rédactrice technique",
        "réalisatrice audiovisuelle",
        "réalisatrice de films d’animation",
        "réalisatrice radio",
        "réceptionniste",
        "réceptionniste en hôtellerie",
        "rectrice",
        "relieuse-doreuse",
        "remailleuse",
        "responsable communication",
        "responsable comptabilité",
        "responsable commerciale export",
        "responsable de boutique",
        "responsable de la gestion des déchets",
        "responsable de laboratoire d’analyses médicales",
        "responsable de magasin",
        "responsable de maintenance industrielle",
        "responsable de production audiovisuelle",
        "responsable de rayon",
        "responsable des achats",
        "responsable des affaires réglementaires",
        "responsable des ressources humaines",
        "responsable du recrutement",
        "responsable événementielle",
        "responsable formation",
        "responsable hygiène sécurité environnement (HSE)",
        "responsable logistique",
        "responsable marketing",
        "responsable paie",
        "responsable qualité",
        "responsable sécurité informatique",
        "responsable supply chain",
        "restauratrice d’art",
        "restauratrice de meubles",
        "restauratrice de peinture",
        "restauratrice du patrimoine",
        "régisseuse de théâtre",
        "régisseuse générale",
        "régisseuse lumière",
        "régisseuse plateau",
        "régisseuse son",
        "régulatrice de production",
        "relieuse",
        "reporter d’images",
        "responsable e-commerce",
        "responsable des relations publiques",
        "responsable développement durable",
        "responsable export",
        "responsable merchandising",
        "responsable packaging",
        "responsable produit",
        "responsable qualité logiciel",
        "responsable relation client",
        "responsable sécurité",
        "responsable sécurité incendie",
        "responsable technique",
        "responsable webmarketing",
        "restauratrice de céramiques",
        "restauratrice de vitraux",
        "réviseuse de comptes",
        "romancière",
        "sage-femme",
        "sapeuse-pompière",
        "scénariste",
        "sculptrice",
        "secrétaire",
        "secrétaire médicale",
        "secrétaire de direction",
        "secrétaire juridique",
        "sellière-garnisseuse",
        "sérigraphe",
        "serveuse",
        "serveuse en restauration",
        "sextante (marine)",
        "sociologue",
        "soldate",
        "solière (industrie des chaussures)",
        "soigneuse animalière",
        "sommelière",
        "soudeuse",
        "statisticienne",
        "stewardesse (hôtesse de l’air)",
        "styliste de mode",
        "styliste ongulaire",
        "substitut du procureur (substitue)",
        "superviseuse de production",
        "superviseuse d’appels",
        "surveillante de prison",
        "surveillante pénitentiaire",
        "sylvicultrice",
        "syndicaliste",
        "tailleuse de pierre",
        "tapissière d’ameublement",
        "tatoueuse",
        "taxidermiste",
        "technicienne agricole",
        "technicienne biologiste",
        "technicienne de laboratoire",
        "technicienne de maintenance",
        "technicienne de mesures physiques",
        "technicienne de production audiovisuelle",
        "technicienne de recherche en biologie",
        "technicienne de traitement des eaux",
        "technicienne de surface",
        "technicienne du son",
        "technicienne en automatisme",
        "technicienne en électrotechnique",
        "technicienne en énergie renouvelable",
        "technicienne en informatique",
        "technicienne en microélectronique",
        "technicienne en optique",
        "technicienne en télécommunications",
        "technicienne forestière",
        "technicienne géomètre",
        "technicienne horticole",
        "technicienne logistique",
        "technicienne météorologique",
        "technicienne méthodes",
        "technicienne paysagiste",
        "technicienne qualité",
        "technicienne réseaux",
        "technicienne systèmes et réseaux",
        "technicienne textile",
        "technicienne audiovisuelle",
        "teinturière",
        "tempographe",
        "terrassière",
        "tisserande",
        "toilière",
        "toilière de parapente",
        "toxicologue",
        "traductrice-interprète",
        "trameuse",
        "transcriptrice",
        "transporteuse de fonds",
        "travaileuse sociale",
        "trésorière",
        "urbaniste",
        "ux designeuse",
        "vendeuse",
        "vendeuse en boulangerie",
        "vendeuse en magasin de sport",
        "vendeuse en prêt-à-porter",
        "vérificatrice",
        "vétérinaire",
        "vigneronne",
        "viticultrice",
        "vitrière",
        "webdesigneuse",
        "webmastereuse",
        "zoologiste",
    ]
