/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.parser;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.execution.RestClientRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlFormData {
    private final String myName;
    private final List<RestClientRequest.KeyValuePair> myHeaders;
    private String myContent;
    private boolean hasFileContent;
    private File myFile;
    private RequestBuilder.ContentTypeInfo myFormContentType;

    public CurlFormData(@NotNull String formData) {
        if (formData == null) {
            CurlFormData.$$$reportNull$$$0(0);
        }
        this.myHeaders = new ArrayList<RestClientRequest.KeyValuePair>();
        this.myFormContentType = new RequestBuilder.ContentTypeInfo("*/*", "UTF-8");
        int equalSignPosition = formData.indexOf(61);
        if (equalSignPosition < 0) {
            throw CurlParseException.newInvalidFormDataException(formData);
        }
        this.myName = formData.substring(0, equalSignPosition);
        int semicolonPosition = formData.indexOf(59);
        String contentString = formData.substring(equalSignPosition + 1, semicolonPosition < 0 ? formData.length() : semicolonPosition);
        this.parseContent(contentString);
        if (semicolonPosition >= 0) {
            this.parseAdditionalOption(formData.substring(semicolonPosition + 1));
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CurlFormData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            CurlFormData.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean hasFileContent() {
        return this.hasFileContent;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public RequestBuilder.ContentTypeInfo getFormContentType() {
        RequestBuilder.ContentTypeInfo contentTypeInfo = this.myFormContentType;
        if (contentTypeInfo == null) {
            CurlFormData.$$$reportNull$$$0(3);
        }
        return contentTypeInfo;
    }

    @NotNull
    public List<RestClientRequest.KeyValuePair> getHeaders() {
        List<RestClientRequest.KeyValuePair> list2 = this.myHeaders;
        if (list2 == null) {
            CurlFormData.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private void parseContent(@NotNull String contentString) {
        if (contentString == null) {
            CurlFormData.$$$reportNull$$$0(5);
        }
        if (contentString.startsWith("@")) {
            this.myContent = contentString.substring(1);
            this.hasFileContent = true;
            this.myFile = new File(this.myContent);
        } else {
            this.myContent = contentString;
            this.hasFileContent = false;
        }
    }

    private void parseAdditionalOption(@NotNull String additionalFormData) {
        int equalSignPosition;
        if (additionalFormData == null) {
            CurlFormData.$$$reportNull$$$0(6);
        }
        if ((equalSignPosition = additionalFormData.indexOf(61)) >= 0) {
            String additionalOptionKey = additionalFormData.substring(0, equalSignPosition);
            String additionalOptionValue = additionalFormData.substring(equalSignPosition + 1).replaceAll("^\"|\"$|^'|'$", "");
            if (additionalOptionKey.equals("filename") && this.hasFileContent) {
                this.myFile = new File(this.myFile.getParent(), additionalOptionValue);
            } else if (additionalOptionKey.equals("type")) {
                this.myFormContentType = new RequestBuilder.ContentTypeInfo(additionalOptionValue, "UTF-8");
            } else if (additionalOptionKey.equals("headers")) {
                int colonPosition = additionalOptionValue.indexOf(58);
                if (colonPosition < 0) {
                    this.myHeaders.add(new RestClientRequest.KeyValuePair(additionalOptionValue, ""));
                } else {
                    this.myHeaders.add(new RestClientRequest.KeyValuePair(additionalOptionValue.substring(0, colonPosition), additionalOptionValue.substring(colonPosition + 1).trim()));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/parser/CurlFormData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFormData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/parser/CurlFormData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormContentType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAdditionalOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

