/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.editor;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestDynamicVariableSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestDynamicVariableSelectioner.$$$reportNull$$$0(0);
        }
        if (element instanceof HttpDynamicVariable) {
            return true;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        if (!(node.getElementType() instanceof HttpRequestTokenType)) {
            return false;
        }
        return HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.DYNAMIC_VARIABLE_IDENTIFIER) || HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.DYNAMIC_SIGN) || HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.MESSAGE_TEXT);
    }

    @Nullable
    public List<TextRange> select(@NotNull PsiElement element, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        List ranges;
        if (element == null) {
            HttpRequestDynamicVariableSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            HttpRequestDynamicVariableSelectioner.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            HttpRequestDynamicVariableSelectioner.$$$reportNull$$$0(3);
        }
        if ((ranges = super.select(element, editorText, cursorOffset, editor2)) == null) {
            return null;
        }
        if (HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.DYNAMIC_SIGN)) {
            if ((element = element.getParent()) instanceof HttpDynamicVariable) {
                ranges.add(element.getTextRange());
            } else {
                return null;
            }
        }
        if (element instanceof HttpDynamicVariable) {
            ASTNode[] childrenNodes = element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.DYNAMIC_SIGN, HttpRequestElementTypes.DYNAMIC_VARIABLE_EXPR}));
            if (childrenNodes.length == 2) {
                ASTNode dynamicSignNode = childrenNodes[0];
                ASTNode identifierNode = childrenNodes[1];
                if (dynamicSignNode != null && identifierNode != null && dynamicSignNode.getTextRange().getStartOffset() <= identifierNode.getTextRange().getEndOffset()) {
                    ranges.add(TextRange.create((int)dynamicSignNode.getTextRange().getStartOffset(), (int)identifierNode.getTextRange().getEndOffset()));
                }
            }
        } else if (HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.MESSAGE_TEXT)) {
            TextRange variableNameRange;
            String messageBodyText = element.getText();
            int bodyStartOffset = element.getTextOffset();
            TextRange variableRangeInBody = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBodyText).stream().filter(range -> range.containsOffset(editor2.getCaretModel().getOffset() - bodyStartOffset)).findFirst().orElse(null);
            if (variableRangeInBody != null && (variableNameRange = HttpRequestPsiUtils.getDynamicVariableNameRange(messageBodyText, variableRangeInBody)) != null) {
                int dynamicSignOffset = messageBodyText.indexOf(HttpRequestElementTypes.DYNAMIC_SIGN.toString(), variableRangeInBody.getStartOffset());
                ranges.add(variableRangeInBody.shiftRight(bodyStartOffset));
                if (dynamicSignOffset > 0 && dynamicSignOffset <= variableNameRange.getStartOffset()) {
                    if (editor2.getCaretModel().getOffset() < variableNameRange.getStartOffset() + bodyStartOffset) {
                        ranges.add(TextRange.create((int)dynamicSignOffset, (int)variableNameRange.getStartOffset()).shiftRight(bodyStartOffset));
                    }
                    ranges.add(TextRange.create((int)dynamicSignOffset, (int)variableNameRange.getEndOffset()).shiftRight(bodyStartOffset));
                }
                ranges.add(variableNameRange.shiftRight(bodyStartOffset));
            }
        }
        return ranges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/editor/HttpRequestDynamicVariableSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

