/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.openai;

import com.intellij.aiplayground.models.LlmModelId;
import com.intellij.aiplayground.openai.ModelDTO;
import com.intellij.aiplayground.openai.ModelsListResponse;
import com.intellij.aiplayground.openai.OpenAiClientAPI;
import com.intellij.aiplayground.openai.OpenAiClientAPIImpl;
import com.intellij.aiplayground.openai.OpenAiClientAPIImplKt;
import com.intellij.aiplayground.openai.OpenAiModel;
import com.intellij.util.net.PlatformHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/aiplayground/openai/OpenAiClientAPIImpl;", "Lcom/intellij/aiplayground/openai/OpenAiClientAPI;", "<init>", "()V", "filterModelsByCreatedAt", "", "Lcom/intellij/aiplayground/openai/ModelDTO;", "models", "filterByCreatedAt", "", "(Ljava/util/List;Ljava/lang/Long;)Ljava/util/List;", "filterAndConvertModels", "Lcom/intellij/aiplayground/openai/OpenAiModel;", "modelDTOs", "listModels", "baseUrl", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.aiplayground.openai"})
@SourceDebugExtension(value={"SMAP\nOpenAiClientAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiClientAPIImpl.kt\ncom/intellij/aiplayground/openai/OpenAiClientAPIImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,174:1\n774#2:175\n865#2,2:176\n774#2:178\n865#2:179\n1761#2,3:180\n1761#2,3:183\n1761#2,3:186\n1761#2,3:189\n866#2:192\n1563#2:193\n1634#2,3:194\n222#3:197\n116#4,11:198\n*S KotlinDebug\n*F\n+ 1 OpenAiClientAPIImpl.kt\ncom/intellij/aiplayground/openai/OpenAiClientAPIImpl\n*L\n52#1:175\n52#1:176,2\n85#1:178\n85#1:179\n94#1:180,3\n99#1:183,3\n104#1:186,3\n121#1:189,3\n85#1:192\n130#1:193\n130#1:194,3\n158#1:197\n161#1:198,11\n*E\n"})
public final class OpenAiClientAPIImpl
implements OpenAiClientAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static List<ModelDTO> cachedModelDTOs;
    private static long cacheTimestamp;
    private static final int cacheDurationMillis;
    @NotNull
    private static final Mutex cacheMutex;

    /*
     * WARNING - void declaration
     */
    private final List<ModelDTO> filterModelsByCreatedAt(List<ModelDTO> models, Long filterByCreatedAt) {
        void $this$filterTo$iv$iv;
        if (filterByCreatedAt == null) {
            return models;
        }
        long currentTimeSeconds = System.currentTimeMillis() / (long)1000;
        Iterable $this$filter$iv = models;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelDTO model = (ModelDTO)element$iv$iv;
            boolean bl = false;
            if (!(currentTimeSeconds - model.getCreated() <= filterByCreatedAt / (long)1000)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenAiModel> filterAndConvertModels(List<ModelDTO> modelDTOs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ModelDTO model;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object[] objectArray = new String[]{"text-embedding", "dall-e", "whisper", "tts-", "gpt-image", "computer-use", "omni-moderation"};
        List nonChatPrefixes = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"-audio", "-realtime", "-search", "-transcribe", "-tts", "-image", "-alpha", "-instruct"};
        List nonChatPatterns = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new String[]{"o1-pro", "o1-pro-2025-03-19"};
        Set specificNonChatModels = SetsKt.setOf((Object[])objectArray3);
        Object[] objectArray4 = new String[]{"gpt-3.5-turbo", "gpt-4-turbo", "gpt-4o-mini", "gpt-4.1", "gpt-4.5", "gpt-5", "chatgpt-"};
        List chatPrefixes = CollectionsKt.listOf((Object[])objectArray4);
        Regex ftPattern = new Regex("^ft:(.+)$");
        Iterable iterable = modelDTOs;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            model = (ModelDTO)element$iv$iv;
            boolean bl2 = false;
            String id = model.getId();
            if (specificNonChatModels.contains(id)) {
                bl = false;
            } else {
                String it;
                boolean bl3;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block27: {
                    $this$any$iv = nonChatPrefixes;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith$default((String)id, (String)it, (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block27;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    bl = false;
                } else {
                    boolean bl5;
                    block28: {
                        $this$any$iv = nonChatPatterns;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl6 = false;
                                if (!StringsKt.contains((CharSequence)id, (CharSequence)it, (boolean)true)) continue;
                                bl5 = true;
                                break block28;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        bl = false;
                    } else {
                        boolean bl7;
                        block29: {
                            $this$any$iv = chatPrefixes;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl8 = false;
                                    if (!StringsKt.startsWith$default((String)id, (String)it, (boolean)false, (int)2, null)) continue;
                                    bl7 = true;
                                    break block29;
                                }
                                bl7 = false;
                            }
                        }
                        if (bl7) {
                            bl = true;
                        } else if ((Intrinsics.areEqual((Object)id, (Object)"o1") || Intrinsics.areEqual((Object)id, (Object)"o3") || Intrinsics.areEqual((Object)id, (Object)"o4") || StringsKt.startsWith$default((String)id, (String)"o1-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)id, (String)"o3-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)id, (String)"o4-", (boolean)false, (int)2, null)) && !StringsKt.contains$default((CharSequence)id, (CharSequence)"-audio", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id, (CharSequence)"-realtime", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id, (CharSequence)"-search", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id, (CharSequence)"-transcribe", (boolean)false, (int)2, null)) {
                            bl = true;
                        } else if (ftPattern.matches((CharSequence)id)) {
                            boolean bl9;
                            Object baseModel;
                            block30: {
                                Object object = Regex.find$default((Regex)ftPattern, (CharSequence)id, (int)0, (int)2, null);
                                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                                    object = "";
                                }
                                baseModel = object;
                                Iterable $this$any$iv2 = chatPrefixes;
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl9 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv2) {
                                        String it2 = (String)element$iv;
                                        boolean bl10 = false;
                                        if (!StringsKt.startsWith$default((String)baseModel, (String)it2, (boolean)false, (int)2, null)) continue;
                                        bl9 = true;
                                        break block30;
                                    }
                                    bl9 = false;
                                }
                            }
                            bl = bl9 || StringsKt.startsWith$default((String)baseModel, (String)"gpt-4o", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)baseModel, (Object)"gpt-4") || StringsKt.startsWith$default((String)baseModel, (String)"gpt-3.5-turbo", (boolean)false, (int)2, null);
                        } else {
                            bl = Intrinsics.areEqual((Object)id, (Object)"gpt-4") || StringsKt.startsWith$default((String)id, (String)"gpt-4o", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)id, (String)"davinci", (boolean)false, (int)2, null);
                        }
                    }
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void modelDTO;
            model = (ModelDTO)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean supportsParameters = !Intrinsics.areEqual((Object)modelDTO.getId(), (Object)"o1") && !Intrinsics.areEqual((Object)modelDTO.getId(), (Object)"o3") && !Intrinsics.areEqual((Object)modelDTO.getId(), (Object)"o4") && !StringsKt.startsWith$default((String)modelDTO.getId(), (String)"o1-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)modelDTO.getId(), (String)"o3-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)modelDTO.getId(), (String)"o4-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)modelDTO.getId(), (String)"gpt-5", (boolean)false, (int)2, null);
            collection.add(new OpenAiModel(LlmModelId.constructor-impl((String)modelDTO.getId()), supportsParameters, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object listModels(@NotNull String baseUrl, @NotNull String apiKey, @Nullable Long filterByCreatedAt, @NotNull Continuation<? super List<OpenAiModel>> $completion) {
        if (!($completion instanceof listModels.1)) ** GOTO lbl-1000
        var18_5 = $completion;
        if ((var18_5.label & -2147483648) != 0) {
            var18_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ OpenAiClientAPIImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listModels(null, null, null, (Continuation<? super List<OpenAiModel>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                currentTime = System.currentTimeMillis();
                if (OpenAiClientAPIImpl.cachedModelDTOs != null && currentTime - OpenAiClientAPIImpl.cacheTimestamp < (long)OpenAiClientAPIImpl.cacheDurationMillis) {
                    v0 = OpenAiClientAPIImpl.cachedModelDTOs;
                    Intrinsics.checkNotNull(v0);
                    filteredData = this.filterModelsByCreatedAt(v0, filterByCreatedAt);
                    return this.filterAndConvertModels(filteredData);
                }
                v1 = PlatformHttpClient.client();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"client(...)");
                client = v1;
                request = PlatformHttpClient.requestBuilder((URI)new URI(baseUrl + "/models")).header("Authorization", "Bearer " + apiKey).build();
                v2 = client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
                Intrinsics.checkNotNullExpressionValue(v2, (String)"sendAsync(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)baseUrl);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiKey);
                $continuation.L$2 = filterByCreatedAt;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.J$0 = currentTime;
                $continuation.label = 1;
                v3 = FutureKt.await((CompletionStage)v2, (Continuation)$continuation);
                if (v3 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl44
            }
            case 1: {
                currentTime = $continuation.J$0;
                request = (HttpRequest)$continuation.L$4;
                client = (HttpClient)$continuation.L$3;
                filterByCreatedAt = (Long)$continuation.L$2;
                apiKey = (String)$continuation.L$1;
                baseUrl = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl44:
                // 2 sources

                if ((responseBody = (String)(theResponse = PlatformHttpClient.checkResponse((HttpResponse)((HttpResponse)v3))).body()) == null) break;
                var12_19 = OpenAiClientAPIImplKt.getOpenAiJson();
                string$iv = responseBody;
                $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                modelsResponse = (ModelsListResponse)this_$iv.decodeFromString((DeserializationStrategy)ModelsListResponse.Companion.serializer(), string$iv);
                $this$withLock_u24default$iv = OpenAiClientAPIImpl.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)baseUrl);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiKey);
                $continuation.L$2 = filterByCreatedAt;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)theResponse);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)responseBody);
                $continuation.L$7 = modelsResponse;
                $continuation.L$8 = $this$withLock_u24default$iv;
                $continuation.J$0 = currentTime;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 2;
                v4 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v4 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl85
            }
            case 2: {
                $i$f$withLock = $continuation.I$0;
                currentTime = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$8;
                modelsResponse = (ModelsListResponse)$continuation.L$7;
                responseBody = (String)$continuation.L$6;
                theResponse = (HttpResponse)$continuation.L$5;
                request = (HttpRequest)$continuation.L$4;
                client = (HttpClient)$continuation.L$3;
                filterByCreatedAt = (Long)$continuation.L$2;
                apiKey = (String)$continuation.L$1;
                baseUrl = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl85:
                // 2 sources

                try {
                    $i$a$-withLock$default-OpenAiClientAPIImpl$listModels$2 = false;
                    OpenAiClientAPIImpl.cachedModelDTOs = modelsResponse.getData();
                    OpenAiClientAPIImpl.cacheTimestamp = System.currentTimeMillis();
                    var16_26 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                filteredData = this.filterModelsByCreatedAt(modelsResponse.getData(), filterByCreatedAt);
                return this.filterAndConvertModels(filteredData);
            }
        }
        throw new IOException("Failed to list models: empty response body");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        cacheDurationMillis = 86400000;
        cacheMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/aiplayground/openai/OpenAiClientAPIImpl$Companion;", "", "<init>", "()V", "cachedModelDTOs", "", "Lcom/intellij/aiplayground/openai/ModelDTO;", "cacheTimestamp", "", "cacheDurationMillis", "", "cacheMutex", "Lkotlinx/coroutines/sync/Mutex;", "intellij.aiplayground.openai"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

