/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.SshCredentialProvider;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshRemoteSdkCredentialsProvider
implements SshCredentialProvider {
    @NotNull
    public Collection<RemoteCredentials> getCredentialsList(@Nullable Project project) throws ExecutionException {
        ArrayList<RemoteCredentials> result = new ArrayList<RemoteCredentials>();
        try {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                RemoteSdkAdditionalData sdkData;
                CredentialsType type;
                SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
                if (!(sdkAdditionalData instanceof RemoteSdkAdditionalData) || !RemoteSdkUtil.isSshCredentialType(type = (sdkData = (RemoteSdkAdditionalData)sdkAdditionalData).getRemoteConnectionType())) continue;
                result.add(sdkData.getRemoteCredentials(project, true));
            }
        }
        catch (InterruptedException ex) {
            throw new ExecutionException((Throwable)ex);
        }
        ArrayList<RemoteCredentials> arrayList = result;
        if (arrayList == null) {
            SshRemoteSdkCredentialsProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/SshRemoteSdkCredentialsProvider", "getCredentialsList"));
    }
}

