/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbNavigationUtils {
    public static boolean isLegacyNavigateToCodeFromTree() {
        return Registry.is((String)"database.legacy.navigate.to.code.from.tree", (boolean)false);
    }

    public static boolean canNavigateToData(DbElement element) {
        DbElement adjusted2 = DbNavigationUtils.adjustForDataNavigation(element);
        return DatabaseEditorHelper.isTableDataAvailable(adjusted2);
    }

    public static boolean canNavigateToSource(DbElement element) {
        return element.canNavigateToSource();
    }

    public static void navigateToData(DbElement element, boolean requestFocus) {
        DbNavigationUtils.navigateToData(element, requestFocus, null, null);
    }

    public static void navigateToData(DbElement element, boolean requestFocus, String @Nullable [] columnNames, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> filterCondition) {
        VirtualFile virtualFile;
        DbElement adjusted2;
        if (columnNames == null && element.getKind() == ObjectKind.COLUMN) {
            columnNames = new String[]{element.getName()};
        }
        if (DatabaseEditorHelper.isTableDataAvailable(adjusted2 = DbNavigationUtils.adjustForDataNavigation(element)) && (virtualFile = DbImplUtil.findDataVirtualFile(adjusted2, false)) != null) {
            new OpenDataFileDescriptor(element.getProject(), virtualFile, columnNames, null, null, filterCondition).navigate(requestFocus);
        }
    }

    public static void navigateToData(DbElement element, ObjectKind family, boolean requestFocus) {
        String path = DatabaseVirtualFileSystem.getPath((String)element.getDataSource().getUniqueId(), (ObjectPath)ObjectPaths.of((DasObject)element), (ObjectKind)family, (boolean)false);
        VirtualFile virtualFile = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (virtualFile != null) {
            new OpenDataFileDescriptor(element.getProject(), virtualFile, null, null, null, null).navigate(requestFocus);
        }
    }

    @NotNull
    public static DbElement adjustForDataNavigation(DbElement element) {
        DbElement adjusted2 = DbTargetUtil.adjustForNavigation(element);
        if (adjusted2 instanceof DbSynonymImpl) {
            adjusted2 = (DbElement)ObjectUtils.notNull((Object)((DbSynonymImpl)adjusted2).resolveTarget(), (Object)adjusted2);
        }
        DbElement dbElement = adjusted2;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(0);
        }
        return dbElement;
    }

    @NotNull
    public static NavigationItem createToDatabaseViewNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(1);
        }
        return new MyNavigationWrapper(element){

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToDatabaseView(this.myElement, requestFocus);
            }
        };
    }

    @NotNull
    public static NavigationItem createToDataOrSourceNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(2);
        }
        if (DbNavigationUtils.canNavigateToData(element)) {
            return DbNavigationUtils.createToDataNavigatable(element);
        }
        return DbNavigationUtils.createToSourceNavigatable(element);
    }

    @NotNull
    public static MyNavigationWrapper createToDataNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(3);
        }
        return new DbToDataNavWrapper(element);
    }

    @NotNull
    public static NavigationItem createToDataSourceFileNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(4);
        }
        return new DbToDsFileNavWrapper(element);
    }

    @NotNull
    public static NavigationItem createToSourceNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(5);
        }
        if (!DbNavigationUtils.canNavigateToData(element)) {
            DbElement dbElement = element;
            if (dbElement == null) {
                DbNavigationUtils.$$$reportNull$$$0(6);
            }
            return dbElement;
        }
        return new DbToSrcNavWrapper(element);
    }

    @NotNull
    public static NavigationItem createFromTreeFamilyNavigatable(final @NotNull DbElement element, final @NotNull ObjectKind family) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(7);
        }
        if (family == null) {
            DbNavigationUtils.$$$reportNull$$$0(8);
        }
        return new NavigationItem(){

            @Nullable
            public String getName() {
                return family.getPresentableName();
            }

            @Nullable
            public ItemPresentation getPresentation() {
                return null;
            }

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToData(element, family, requestFocus);
            }

            public boolean canNavigate() {
                return true;
            }
        };
    }

    @NotNull
    public static NavigationItem createFromTreeNavigatable(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(9);
        }
        if (DbNavigationUtils.isLegacyNavigateToCodeFromTree()) {
            if (DbNavigationUtils.canNavigateToDataSourceFile(element)) {
                return DbNavigationUtils.createToDataSourceFileNavigatable(element);
            }
            return DbNavigationUtils.createToSourceNavigatable(element);
        }
        if (DbNavigationUtils.canNavigateToData(element)) {
            return DbNavigationUtils.createToDataNavigatable(element);
        }
        if (DbNavigationUtils.canNavigateToDataSourceFile(element)) {
            return DbNavigationUtils.createToDataSourceFileNavigatable(element);
        }
        return DbNavigationUtils.createToSourceNavigatable(element);
    }

    public static PsiElement unwrapNavWrapper(@Nullable Navigatable element) {
        return element instanceof PsiElementNavigationItem ? ((PsiElementNavigationItem)element).getTargetElement() : (PsiElement)ObjectUtils.tryCast((Object)element, PsiElement.class);
    }

    public static DbElement extractDbElementFromPsi(@NotNull PsiElement e) {
        if (e == null) {
            DbNavigationUtils.$$$reportNull$$$0(10);
        }
        if (e instanceof DbElement) {
            return (DbElement)e;
        }
        JBIterable<DasObject> objects = DbNavigationUtils.unwrapElements(e);
        if (objects != null) {
            return (DbElement)objects.filter(DbElement.class).first();
        }
        return null;
    }

    @Contract(value="null->null")
    public static DbElement extractDbElement(@Nullable Navigatable navigatable) {
        return (DbElement)ObjectUtils.tryCast((Object)DbNavigationUtils.unwrapNavWrapper(navigatable), DbElement.class);
    }

    public static boolean isToSourceNavigatable(@Nullable Navigatable navigatable) {
        return navigatable instanceof DbToSrcNavWrapper || navigatable instanceof DbElement;
    }

    public static void navigateToDatabaseView(@NotNull DbElement element, boolean requestFocus) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(11);
        }
        DatabaseView.select(element.getProject(), Collections.singleton(element), requestFocus, true);
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        VirtualFile file;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(12);
        }
        if (DbNavigationUtils.navigateToSqlElement(dbElement, requestFocus)) {
            return;
        }
        VirtualFile virtualFile = file = dbElement instanceof DbDataSource ? null : DbTargetUtil.getContainingFile(dbElement, true);
        if (file != null) {
            Project project = dbElement.getProject();
            Runnable runnable = () -> {
                int offset = (Integer)ActionUtil.underModalProgress((Project)dbElement.getProject(), (String)DatabaseBundle.message((String)"progress.title.computing.target.symbol", (Object[])new Object[0]), () -> DbTargetUtil.calcTargetOffset(project, file, (DasObject)dbElement));
                PsiNavigationSupport.getInstance().createNavigatable(project, file, offset).navigate(requestFocus);
            };
            DatabaseElementSourceVirtualFileImpl vf = (DatabaseElementSourceVirtualFileImpl)ObjectUtils.tryCast((Object)file, DatabaseElementSourceVirtualFileImpl.class);
            if (vf != null && DatabaseEditorHelper.needsReload(vf)) {
                DatabaseEditorHelper.reloadIfNeeded(project, vf).onSuccess(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
                PsiNavigationSupport.getInstance().createNavigatable(project, file, 0).navigate(requestFocus);
            } else {
                runnable.run();
            }
        } else {
            DbNavigationUtils.navigateToDatabaseView(dbElement, requestFocus);
        }
    }

    public static boolean canNavigateToDataSourceFile(@NotNull DbElement element) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(13);
        }
        return element instanceof DbDataSource || element instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource((DasDataSource)element.getDataSource()) != null;
    }

    public static void navigateToDataSourceFile(@NotNull DbElement element, boolean requestFocus) {
        if (element == null) {
            DbNavigationUtils.$$$reportNull$$$0(14);
        }
        if (element instanceof DbDataSource) {
            VirtualFile virtualFile;
            RawDataSource delegate = ((DbDataSource)element).getDelegate();
            if (delegate instanceof SqlDataSource) {
                virtualFile = (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getRoots());
            } else {
                virtualFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)delegate);
                if (virtualFile == null) {
                    virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)delegate);
                }
            }
            if (virtualFile != null) {
                PsiNavigationSupport.getInstance().createNavigatable(element.getProject(), virtualFile, -1).navigate(requestFocus);
            } else {
                String message = delegate instanceof SqlDataSource ? DatabaseBundle.message((String)"dialog.message.no.source.for.ddl.data.source", (Object[])new Object[0]) : DatabaseBundle.message((String)"dialog.message.no.console.for.data.source", (Object[])new Object[0]);
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), null, (String)message, (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
            }
        } else if (element instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource((DasDataSource)element.getDataSource()) != null) {
            DbDataSource dataSource = element.getDataSource();
            VirtualFile virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource.getDelegate());
            if (virtualFile != null) {
                DatabaseEditorHelper.openConsoleForFile(element.getProject(), (DasDataSource)dataSource, (DasNamespace)element.getDelegate(), virtualFile);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), null, (String)DatabaseBundle.message((String)"dialog.message.no.console.for.data.source", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
            }
        }
    }

    private static boolean navigateToSqlElement(@NotNull DbElement dbElement, boolean requestFocus) {
        Navigatable descriptor2;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(15);
        }
        if (!DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        DasObject source = (DasObject)ActionUtil.underModalProgress((Project)dbElement.getProject(), (String)DatabaseBundle.message((String)"progress.title.computing.target.symbol", (Object[])new Object[0]), () -> DbSqlUtil.getSqlSourceElement(dbElement));
        if (source instanceof DbElement) {
            if (source == dbElement) {
                CommonRefactoringUtil.showErrorHint((Project)dbElement.getProject(), null, (String)DatabaseBundle.message((String)"dialog.message.no.code.for.item", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
            } else {
                DbNavigationUtils.navigateToSource((DbElement)source, requestFocus);
            }
            return true;
        }
        PsiElement psi = source instanceof PsiElement ? (PsiElement)source : (source instanceof DasSymbol ? ((DasSymbol)source).getNavigationElement() : null);
        Navigatable navigatable = descriptor2 = psi == null ? null : PsiNavigationSupport.getInstance().getDescriptor(psi);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)dbElement.getProject(), null, (String)DatabaseBundle.message((String)"dialog.message.no.code.for.item", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
        }
        return true;
    }

    @Nullable
    public static JBIterable<DasObject> unwrapElements(@Nullable PsiElement element) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell((PsiElement)element);
        if (cell != null) {
            return cell.rows.asIterable().filterMap(i -> DataGridUtil.getDatabaseObject(cell.dataGrid, (ModelIndex<GridRow>)i)).append((Iterable)cell.columns.asIterable().filterMap(i -> DataGridUtil.getDatabaseColumn((CoreGrid<GridRow, GridColumn>)cell.dataGrid, (ModelIndex<GridColumn>)i)));
        }
        DataGridPomTarget.Column column2 = DataGridPomTarget.unwrapColumn((PsiElement)element);
        if (column2 != null) {
            return JBIterable.of((Object)DataGridUtil.getDatabaseColumn((CoreGrid<GridRow, GridColumn>)column2.dataGrid, (ModelIndex<GridColumn>)column2.column));
        }
        DataGrid grid = DataGridPomTarget.unwrapDataGrid((PsiElement)element);
        return grid == null ? null : JBIterable.of((Object)DataGridUtilCore.getDatabaseTable((CoreGrid)grid));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForDataNavigation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToSourceNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToDatabaseViewNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToDataOrSourceNavigatable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToDataNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToDataSourceFileNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToSourceNavigatable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFromTreeFamilyNavigatable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFromTreeNavigatable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractDbElementFromPsi";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDatabaseView";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateToDataSourceFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSourceFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSqlElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    protected static abstract class MyNavigationWrapper
    implements PsiElementNavigationItem,
    ItemPresentation {
        @NotNull
        protected final DbElementImpl<?> myElement;

        public MyNavigationWrapper(@NotNull DbElement element) {
            if (element == null) {
                MyNavigationWrapper.$$$reportNull$$$0(0);
            }
            this.myElement = (DbElementImpl)element;
        }

        @Nullable
        public PsiElement getTargetElement() {
            return this.myElement;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public String getName() {
            return this.myElement.getName();
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass() && this.myElement.isEquivalentTo((PsiElement)((MyNavigationWrapper)obj).myElement);
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.myElement.getIcon(open);
        }

        public String getPresentableText() {
            return this.myElement.getPresentableText();
        }

        @NlsSafe
        @Nullable
        public String getLocationString() {
            return this.myElement.getLocationString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$MyNavigationWrapper", "<init>"));
        }
    }

    private static class DbToDataNavWrapper
    extends MyNavigationWrapper {
        DbToDataNavWrapper(@NotNull DbElement element) {
            if (element == null) {
                DbToDataNavWrapper.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public void navigate(boolean requestFocus) {
            DbNavigationUtils.navigateToData(this.myElement, requestFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToDataNavWrapper", "<init>"));
        }
    }

    private static class DbToDsFileNavWrapper
    extends MyNavigationWrapper {
        DbToDsFileNavWrapper(@NotNull DbElement element) {
            if (element == null) {
                DbToDsFileNavWrapper.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public void navigate(boolean requestFocus) {
            DbNavigationUtils.navigateToDataSourceFile(this.myElement, requestFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToDsFileNavWrapper", "<init>"));
        }
    }

    private static class DbToSrcNavWrapper
    extends MyNavigationWrapper {
        DbToSrcNavWrapper(@NotNull DbElement element) {
            if (element == null) {
                DbToSrcNavWrapper.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public void navigate(boolean requestFocus) {
            this.myElement.navigate(requestFocus);
        }

        @Override
        public String getPresentableText() {
            return super.getPresentableText() + (DbNavigationUtils.canNavigateToData(this.myElement) ? " (DDL)" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToSrcNavWrapper", "<init>"));
        }
    }
}

