/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.database.model.DasObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SqlNavigationLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(2);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)((PsiElement)ContainerUtil.getFirstItem(elements)));
        NavigationHelper navHelper = (NavigationHelper)NavigationHelper.EP.forDbms(dialect.getDbms());
        for (PsiElement psiElement : elements) {
            Pair defs;
            SqlDefinition def;
            if (!(psiElement instanceof SqlReferenceExpression) || (def = (SqlDefinition)ObjectUtils.tryCast((Object)psiElement.getParent(), SqlDefinition.class)) == null || def.getNameElement() != psiElement) continue;
            @NlsContexts.PopupTitle Pair supers = navHelper.findSuperDefinitions((DasObject)def, true);
            if (supers != null) {
                result.add(SqlNavigationLineMarkerProvider.createSuperNavigatable(navHelper, def, (String)supers.first));
            }
            if ((defs = navHelper.findDefinitions((DasObject)def, true)) == null) continue;
            result.add(SqlNavigationLineMarkerProvider.createDefsNavigatable(navHelper, def, (String)defs.first));
        }
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createSuperNavigatable(NavigationHelper navHelper, SqlDefinition def, @NlsActions.ActionText String name2) {
        String actionId = "GotoSuperMethod";
        String tooltip = SqlNavigationLineMarkerProvider.composeText(name2, actionId);
        SqlElement target = (SqlElement)ObjectUtils.notNull((Object)def.getNameElement(), (Object)def);
        LineMarkerInfo info2 = new LineMarkerInfo(PsiTreeUtil.getDeepestFirst((PsiElement)target), target.getTextRange(), AllIcons.Gutter.ImplementingMethod, Functions.constant((Object)tooltip), (e, identifier) -> {
            SqlDefinition tgt = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlDefinition.class);
            if (tgt == null) {
                return;
            }
            @NlsContexts.PopupTitle Pair tgtSupers = navHelper.findSuperDefinitions((DasObject)tgt, false);
            if (tgtSupers == null) {
                return;
            }
            JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])((NavigatablePsiElement[])((JBIterable)tgtSupers.second).filter(NavigatablePsiElement.class).toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY)), (String)((String)tgtSupers.first), null, (ListCellRenderer)new DefaultPsiElementCellRenderer(), null);
            if (popup2 != null) {
                popup2.showInScreenCoordinates(e.getComponent(), e.getPoint());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info2, (String)name2, (String)actionId);
        LineMarkerInfo lineMarkerInfo = info2;
        if (lineMarkerInfo == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createDefsNavigatable(NavigationHelper navHelper, SqlDefinition def, @NlsActions.ActionText String name2) {
        String actionId = "GotoImplementation";
        String tooltip = SqlNavigationLineMarkerProvider.composeText(name2, actionId);
        SqlElement target = (SqlElement)ObjectUtils.notNull((Object)def.getNameElement(), (Object)def);
        LineMarkerInfo info2 = new LineMarkerInfo(PsiTreeUtil.getDeepestFirst((PsiElement)target), target.getTextRange(), AllIcons.Gutter.ImplementedMethod, Functions.constant((Object)tooltip), (e, identifier) -> {
            SqlDefinition tgt = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlDefinition.class);
            if (tgt == null) {
                return;
            }
            @NlsContexts.PopupTitle Pair defs = navHelper.findDefinitions((DasObject)tgt, false);
            if (defs == null) {
                return;
            }
            JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])((NavigatablePsiElement[])((JBIterable)defs.second).filter(NavigatablePsiElement.class).toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY)), (String)((String)defs.first), null, (ListCellRenderer)new DefaultPsiElementCellRenderer(), null);
            if (popup2 != null) {
                popup2.showInScreenCoordinates(e.getComponent(), e.getPoint());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info2, (String)name2, (String)actionId);
        LineMarkerInfo lineMarkerInfo = info2;
        if (lineMarkerInfo == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return lineMarkerInfo;
    }

    @NlsContexts.Tooltip
    @NotNull
    private static String composeText(@Nls @NotNull String start2, @NotNull String actionId) {
        if (start2 == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (actionId == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(6);
        }
        Object[] shortcuts = ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts();
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcuts);
        String string = SqlBundle.message((String)"SqlNavigationLineMarkerProvider.tooltip", (Object[])new Object[]{start2, shortcut == null ? "" : KeymapUtil.getShortcutText((Shortcut)shortcut), shortcut != null ? 0 : 1});
        if (string == null) {
            SqlNavigationLineMarkerProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlNavigationLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlNavigationLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuperNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefsNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "composeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "composeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

