/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.inspections;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.cython.CythonBundle;
import com.intellij.python.pro.cython.psi.CythonCImportElement;
import com.intellij.python.pro.cython.psi.CythonFile;
import com.intellij.python.pro.cython.psi.CythonVariable;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/python/pro/cython/inspections/CythonUsageBeforeDeclarationInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python"})
public final class CythonUsageBeforeDeclarationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (holder.getFile() instanceof CythonFile) {
            TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext((LocalInspectionToolSession)session);
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
            return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
        return psiElementVisitor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/pro/cython/inspections/CythonUsageBeforeDeclarationInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyReferenceExpression", "", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "isReferenceToCythonVariable", "", "hasGlobalScope", "intellij.python"})
    @SourceDebugExtension(value={"SMAP\nCythonUsageBeforeDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CythonUsageBeforeDeclarationInspection.kt\ncom/intellij/python/pro/cython/inspections/CythonUsageBeforeDeclarationInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,74:1\n12637#2,2:75\n*S KotlinDebug\n*F\n+ 1 CythonUsageBeforeDeclarationInspection.kt\ncom/intellij/python/pro/cython/inspections/CythonUsageBeforeDeclarationInspection$Visitor\n*L\n70#1:75,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            if (!this.isReferenceToCythonVariable(node) || this.hasGlobalScope(node)) {
                return;
            }
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)((PsiElement)node));
            CythonFile cythonFile = scopeOwner instanceof CythonFile ? (CythonFile)scopeOwner : null;
            if (cythonFile == null) {
                return;
            }
            CythonFile scopeOwner2 = cythonFile;
            String string = node.getName();
            Intrinsics.checkNotNull((Object)string);
            String name = string;
            List list = PyDefUseUtil.getLatestDefs((ScopeOwner)scopeOwner2, (String)name, (PsiElement)((PsiElement)node), (boolean)false, (boolean)false, (TypeEvalContext)this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLatestDefs(...)");
            boolean declared = SequencesKt.any((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), Visitor::visitPyReferenceExpression$lambda$0), Visitor::visitPyReferenceExpression$lambda$1));
            if (!declared) {
                Object[] objectArray = new Object[]{name};
                this.registerProblem((PsiElement)node, CythonBundle.message("INSP.cython.variable.usage.before.declaration.problem", objectArray));
            }
        }

        private final boolean isReferenceToCythonVariable(PyReferenceExpression node) {
            Object[] objectArray = node.getReference(PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext)).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"multiResolve(...)");
            Object[] declarations = objectArray;
            return SequencesKt.any((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])declarations), Visitor::isReferenceToCythonVariable$lambda$2), arg_0 -> Visitor.isReferenceToCythonVariable$lambda$3(this, arg_0)), Visitor::isReferenceToCythonVariable$lambda$4));
        }

        private final boolean hasGlobalScope(PyReferenceExpression node) {
            boolean bl;
            block1: {
                ResolveResult[] resolveResultArray = node.getReference().multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                Object[] $this$any$iv = resolveResultArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ResolveResult it = (ResolveResult)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ImportedResolveResult && ((ImportedResolveResult)it).getDefiner() instanceof CythonCImportElement)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private static final PsiElement visitPyReferenceExpression$lambda$0(Instruction it) {
            return it.getElement();
        }

        private static final boolean visitPyReferenceExpression$lambda$1(PsiElement it) {
            return it instanceof CythonVariable || PsiTreeUtil.getParentOfType((PsiElement)it, CythonVariable.class) != null;
        }

        private static final PsiElement isReferenceToCythonVariable$lambda$2(ResolveResult it) {
            return it.getElement();
        }

        private static final boolean isReferenceToCythonVariable$lambda$3(Visitor this$0, PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.myTypeEvalContext.maySwitchToAST(it);
        }

        private static final CythonVariable isReferenceToCythonVariable$lambda$4(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CythonVariable cythonVariable = it instanceof CythonVariable ? (CythonVariable)it : null;
            if (cythonVariable == null) {
                cythonVariable = (CythonVariable)PsiTreeUtil.getParentOfType((PsiElement)it, CythonVariable.class);
            }
            return cythonVariable;
        }
    }
}

