/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateProjectModel
extends UserDataHolderBase {
    public Scenario scenario;
    private WebServerConfig server;
    private WebServerConfig.RemotePath serverPath;
    @NlsSafe
    public String localPath;
    public String projectName;
    public String webPath;
    private PublishConfig config;
    private boolean isDefaultConfigUsed = true;
    private final MultiMap<String, WebServerConfig.RemotePath> myRemoteActionPaths = new MultiMap();
    private final MultiMap<String, VirtualFile> myLocalActionPaths = new MultiMap();

    public CreateProjectModel() {
        this.resetConfig();
    }

    public WebServerConfig getServer() {
        return this.server;
    }

    public void setServer(WebServerConfig server) {
        if (this.server != server) {
            this.setServerPath(null);
            this.webPath = null;
        }
        this.server = server;
    }

    public WebServerConfig.RemotePath getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(@Nullable WebServerConfig.RemotePath serverPath) {
        if (!Comparing.equal((Object)this.serverPath, (Object)serverPath)) {
            this.serverPath = serverPath;
            this.webPath = null;
        }
    }

    public List<WebServerConfig> getServersForCurrentScenario() {
        return CreateProjectModel.getServers(this.scenario);
    }

    public static List<WebServerConfig> getServers(Scenario scenario) {
        ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
        for (WebServerConfig server : GroupedServersConfigManager.getInstance(null).getFlattenedServers()) {
            if (!ArrayUtil.contains((Object)((Object)server.getFileTransferConfig().getAccessType()), (Object[])scenario.accessTypes)) continue;
            result.add(server);
        }
        return result;
    }

    public void resetConfig() {
        PublishConfig defaultConfig = PublishConfig.getInstance(ProjectManager.getInstance().getDefaultProject());
        PublishConfig newConfig = new PublishConfig(null);
        defaultConfig.copyTo(newConfig);
        if (this.config != null) {
            newConfig.setExcludedPaths(this.config.getAllExcludedPaths());
            newConfig.setPathMappings(this.config.getAllPathMappings());
        }
        this.config = newConfig;
    }

    public PublishConfig getConfig() {
        return this.config;
    }

    public boolean isDefaultConfigUsed() {
        return this.isDefaultConfigUsed;
    }

    public void setDefaultConfigUsed(boolean defaultConfigUsed) {
        this.isDefaultConfigUsed = defaultConfigUsed;
    }

    @NotNull
    public MultiMap<String, WebServerConfig.RemotePath> getRemoteActionPaths() {
        MultiMap<String, WebServerConfig.RemotePath> multiMap = this.myRemoteActionPaths;
        if (multiMap == null) {
            CreateProjectModel.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, VirtualFile> getLocalActionPaths() {
        MultiMap<String, VirtualFile> multiMap = this.myLocalActionPaths;
        if (multiMap == null) {
            CreateProjectModel.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateProjectModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteActionPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalActionPaths";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum Scenario {
        LocalServer(AccessType.LOCAL),
        MountedServer(AccessType.MOUNT),
        FtpSftpServer(AccessType.SFTP, AccessType.FTP, AccessType.FTPS, AccessType.WEBDAV),
        NoServer(new AccessType[0]);

        public final AccessType[] accessTypes;

        private Scenario(AccessType ... types) {
            this.accessTypes = types;
        }
    }
}

