/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSBitwiseOperatorUsageInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSBitwiseOperatorUsageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSBitwiseOperatorUsageInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
                IElementType sign;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSTokenTypes.AND.equals(sign = node.getOperationSign()) && !JSTokenTypes.OR.equals(sign)) {
                    return;
                }
                JSType type2 = JSDialectSpecificHandlersFactory.findExpectedType(node);
                if (!(type2 instanceof JSBooleanType)) {
                    return;
                }
                JSExpression rOperand = node.getROperand();
                JSExpression lOperand = node.getLOperand();
                JSType rType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(rOperand);
                JSType lType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(lOperand);
                if (JSBitwiseOperatorUsageInspection.isAcceptableTypeForBitwiseOperation(rType) && JSBitwiseOperatorUsageInspection.isAcceptableTypeForBitwiseOperation(lType)) {
                    return;
                }
                ASTNode astNode = node.getNode();
                JSBinaryExpression problemNode = astNode != null ? astNode.findChildByType(sign).getPsi() : node;
                holder.registerProblem((PsiElement)problemNode, JavaScriptBundle.message("js.bitwise.operator.usage.popup", new Object[0]), new LocalQuickFix[]{new ReplaceBitwiseOperatorQuickFix(sign)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$1", "visitJSBinaryExpression"));
            }
        };
    }

    private static boolean isAcceptableTypeForBitwiseOperation(@Nullable JSType rType) {
        if (rType == null) {
            return false;
        }
        if (rType instanceof JSNumberType) {
            return true;
        }
        if (rType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)rType).resolveType();
            return info.isEnum() || info.isEnumLiteral();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ReplaceBitwiseOperatorQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final IElementType myNewOperator;
        private final String myNewOperatorText;

        ReplaceBitwiseOperatorQuickFix(IElementType originalOperator) {
            if (JSTokenTypes.AND.equals(originalOperator)) {
                this.myNewOperator = JSTokenTypes.ANDAND;
            } else if (JSTokenTypes.OR.equals(originalOperator)) {
                this.myNewOperator = JSTokenTypes.OROR;
            } else {
                throw new IllegalArgumentException("Replace bitwise operator must be & or |");
            }
            this.myNewOperatorText = JSTokenTypes.ANDAND.equals(this.myNewOperator) ? "&&" : "||";
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.bitwise.operator.usage.quickfix", this.myNewOperatorText);
            if (string == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element2, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(3);
            }
            if (element2 instanceof LeafElement) {
                LeafElement oldLeaf = (LeafElement)element2;
                LeafElement newLeaf = ASTFactory.leaf((IElementType)this.myNewOperator, (CharSequence)this.myNewOperatorText);
                CodeEditUtil.setNodeGenerated((ASTNode)newLeaf, (boolean)true);
                oldLeaf.getTreeParent().replaceChild((ASTNode)oldLeaf, (ASTNode)newLeaf);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

