/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ExecuteBatchQuery;
import com.intellij.database.remote.dbimport.QueryWithParameters;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class PreparedBatchQuery
extends QueryWithParameters {
    private final List<PreparedBatchQuery> myPreviousBatchQueries;
    private boolean myExecuted;

    PreparedBatchQuery(@NotNull BatchRecords parameters, @NotNull RemotePreparedStatement preparedStatement, @NotNull RemotePreparedStatement oneLineStatement, @NotNull Consumer<ErrorRecord> errorConsumer, @NotNull List<ColumnInfo> infos, @NotNull List<PreparedBatchQuery> queries) {
        if (parameters == null) {
            PreparedBatchQuery.$$$reportNull$$$0(0);
        }
        if (preparedStatement == null) {
            PreparedBatchQuery.$$$reportNull$$$0(1);
        }
        if (oneLineStatement == null) {
            PreparedBatchQuery.$$$reportNull$$$0(2);
        }
        if (errorConsumer == null) {
            PreparedBatchQuery.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            PreparedBatchQuery.$$$reportNull$$$0(4);
        }
        if (queries == null) {
            PreparedBatchQuery.$$$reportNull$$$0(5);
        }
        super(parameters, preparedStatement, oneLineStatement, infos, errorConsumer);
        this.myPreviousBatchQueries = queries;
    }

    @Override
    void statementCompleted() throws RemoteException, SQLException {
        this.myPreparedStatement.addBatch();
    }

    public void executeWithoutBatch() throws RemoteException, SQLException {
        if (this.myExecuted) {
            return;
        }
        this.myExecuted = true;
        try {
            this.completeStatement();
            this.myPreparedStatement.executeUpdate();
        }
        catch (RemoteBatchPreparedStatementImpl.IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException ex) {
            this.executeWithoutMultiLines();
        }
    }

    @Override
    protected void onError() throws RemoteException, SQLException {
        this.myPreparedStatement.clearBatch();
        ExecuteBatchQuery.executeWithoutBatch(this.myPreviousBatchQueries, this.myPreviousBatchQueries.size());
        this.executeWithoutBatch();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "preparedStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oneLineStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "errorConsumer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "infos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "queries";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/remote/dbimport/PreparedBatchQuery";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

