var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { useState, useContext } from 'react';
import { CollapseButton } from '../../components';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { filterObjectsByTags } from '../../helpers/sidebar';
var SidebarContext = React.createContext({
    setShowSidebar: function (value) { return value; },
});
export var Sidebar = function () {
    var _a, _b, _c;
    var _d = useState(false), showSidebar = _d[0], setShowSidebar = _d[1];
    var asyncapi = useSpec();
    var config = useConfig();
    var info = asyncapi.info();
    var logo = (_a = info.extensions().get('x-logo')) === null || _a === void 0 ? void 0 : _a.value();
    var components = asyncapi.components();
    var messages = components === null || components === void 0 ? void 0 : components.messages().all();
    var schemas = components === null || components === void 0 ? void 0 : components.schemas().all();
    var hasOperations = asyncapi.operations().length > 0;
    var showMessages = (_b = config.show) === null || _b === void 0 ? void 0 : _b.messages;
    var showSchemas = (_c = config.show) === null || _c === void 0 ? void 0 : _c.schemas;
    var messagesList = (messages === null || messages === void 0 ? void 0 : messages.length) > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#messages", onClick: function () { return setShowSidebar(false); } }, "Messages"),
        React.createElement("ul", { className: "text-sm mt-2" }, messages.map(function (message, index) {
            var _a, _b;
            return (React.createElement("li", { key: "menu-message-list-".concat((_a = message.name()) !== null && _a !== void 0 ? _a : index) },
                React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#message-".concat((_b = message.name()) !== null && _b !== void 0 ? _b : message.id()), onClick: function () { return setShowSidebar(false); } },
                    React.createElement("div", { className: "break-all inline-block" }, message.id()))));
        }))));
    var schemasList = (schemas === null || schemas === void 0 ? void 0 : schemas.length) > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#schemas", onClick: function () { return setShowSidebar(false); } }, "Schemas"),
        React.createElement("ul", { className: "text-sm mt-2" }, schemas.map(function (schema, index) {
            var _a;
            return (React.createElement("li", { key: "menu-message-list-".concat((_a = schema.id()) !== null && _a !== void 0 ? _a : index) },
                React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#schema-".concat(schema.id()), onClick: function () { return setShowSidebar(false); } },
                    React.createElement("div", { className: "break-all inline-block" }, schema.id()))));
        }))));
    var operationList = hasOperations && (React.createElement(React.Fragment, null,
        React.createElement("li", { className: "mb-3 mt-9" },
            React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#operations", onClick: function () { return setShowSidebar(false); } }, "Operations"),
            React.createElement(OperationsList, null)),
        showMessages && messagesList,
        showSchemas && schemasList));
    return (React.createElement(SidebarContext.Provider, { value: { setShowSidebar: setShowSidebar } },
        React.createElement("div", { className: "burger-menu rounded-full h-16 w-16 bg-white fixed bottom-16 right-8 flex items-center justify-center z-30 cursor-pointer shadow-md bg-teal-500", onClick: function () { return setShowSidebar(function (prev) { return !prev; }); }, "data-lol": showSidebar },
            React.createElement("svg", { viewBox: "0 0 100 70", width: "40", height: "30", className: "fill-current text-gray-200" },
                React.createElement("rect", { width: "100", height: "10" }),
                React.createElement("rect", { y: "30", width: "100", height: "10" }),
                React.createElement("rect", { y: "60", width: "100", height: "10" }))),
        React.createElement("div", { className: "".concat(showSidebar ? 'block fixed w-full' : 'hidden', " sidebar relative w-64 max-h-screen h-full bg-gray-200 shadow z-20") },
            React.createElement("div", { className: "".concat(showSidebar ? 'sidebar--wrapper' : '', " block fixed max-h-screen h-full font-sans px-4 pt-8 pb-16 overflow-y-auto bg-gray-200") },
                React.createElement("div", { className: "sidebar--content" },
                    React.createElement("div", null, logo ? (React.createElement("img", { src: logo, alt: "".concat(info.title(), " logo, ").concat(info.version(), " version") })) : (React.createElement("h1", { className: "text-2xl font-light" },
                        info.title(),
                        " ",
                        info.version()))),
                    React.createElement("ul", { className: "text-sm mt-10 relative" },
                        React.createElement("li", { className: "mb-3" },
                            React.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#introduction", onClick: function () { return setShowSidebar(false); } }, "Introduction")),
                        asyncapi.servers().length > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
                            React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#servers", onClick: function () { return setShowSidebar(false); } }, "Servers"),
                            React.createElement(ServersList, null))),
                        operationList))))));
};
var ServersList = function () {
    var _a, _b;
    var sidebarConfig = useConfig().sidebar;
    var asyncapi = useSpec();
    var servers = asyncapi.servers().all();
    var showServers = (_a = sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showServers) !== null && _a !== void 0 ? _a : 'byDefault';
    if (showServers === 'byDefault') {
        return (React.createElement("ul", { className: "text-sm mt-2" }, servers.map(function (server) { return (React.createElement(ServerItem, { serverName: server.id(), key: server.id() })); })));
    }
    var specTagNames;
    if (showServers === 'bySpecTags') {
        specTagNames = ((_b = asyncapi.info().tags().all()) !== null && _b !== void 0 ? _b : []).map(function (tag) {
            return tag.name();
        });
    }
    else {
        var serverTagNamesSet_1 = new Set();
        servers.forEach(function (server) {
            server.tags().forEach(function (t) { return serverTagNamesSet_1.add(t.name()); });
        });
        specTagNames = Array.from(serverTagNamesSet_1);
    }
    var serializedServers = servers.map(function (server) { return ({
        name: server.id(),
        tags: server.tags(),
        data: {},
    }); });
    var _c = filterObjectsByTags(specTagNames, serializedServers), tagged = _c.tagged, untagged = _c.untagged;
    return (React.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedServers = _a[1];
            return (React.createElement("li", { key: tag },
                React.createElement(ItemsByTagItem, { tagName: tag }, taggedServers.map(function (_a) {
                    var serverName = _a.name;
                    return (React.createElement(ServerItem, { serverName: serverName, key: serverName }));
                }))));
        }),
        untagged.length > 0 ? (React.createElement("li", null,
            React.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var serverName = _a.name;
                return (React.createElement(ServerItem, { serverName: serverName, key: serverName }));
            })))) : null));
};
var OperationsList = function () {
    var _a, _b;
    var config = useConfig();
    var sidebarConfig = config.sidebar;
    var asyncapi = useSpec();
    var operations = asyncapi.operations().all();
    var showOperations = (_a = sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showOperations) !== null && _a !== void 0 ? _a : 'byDefault';
    var processedOperations = operations.map(function (operation) {
        var _a, _b, _c;
        var operationChannel = operation.channels();
        var operationHrefId = CommonHelpers.getOperationIdentifier({
            operation: operation,
            config: config,
        });
        var type = CommonHelpers.getOperationType(operation);
        var specV = asyncapi.version();
        var version = specV.localeCompare('2.6.0', undefined, {
            numeric: true,
        });
        var label = '';
        if (version === 0 || (sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.useChannelAddressAsIdentifier)) {
            var operationChannels = operationChannel.all();
            var channelAddress = (_b = (_a = operationChannels[0]) === null || _a === void 0 ? void 0 : _a.address()) !== null && _b !== void 0 ? _b : '';
            var operationSummary = operation.summary();
            label = operationSummary !== null && operationSummary !== void 0 ? operationSummary : channelAddress;
        }
        else {
            label = (_c = operation.id()) !== null && _c !== void 0 ? _c : '';
        }
        return {
            name: "".concat(type, "-").concat(operation.id()),
            tags: operation.tags(),
            data: {
                label: label,
                type: type,
                operationHrefId: operationHrefId,
            },
        };
    });
    if (showOperations === 'byDefault') {
        return (React.createElement("ul", { className: "text-sm mt-2" }, processedOperations.map(function (_a) {
            var name = _a.name, data = _a.data;
            return (React.createElement(OperationItem, __assign({ key: name }, data)));
        })));
    }
    var operationTagNames;
    if (showOperations === 'bySpecTags') {
        operationTagNames = ((_b = asyncapi.info().tags().all()) !== null && _b !== void 0 ? _b : []).map(function (tag) {
            return tag.name();
        });
    }
    else {
        var operationTagNamesSet_1 = new Set();
        operations.forEach(function (operation) {
            operation
                .tags()
                .all()
                .forEach(function (t) { return operationTagNamesSet_1.add(t.name()); });
        });
        operationTagNames = Array.from(operationTagNamesSet_1);
    }
    var _c = filterObjectsByTags(operationTagNames, processedOperations), tagged = _c.tagged, untagged = _c.untagged;
    return (React.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedOperations = _a[1];
            return (React.createElement("li", { key: tag },
                React.createElement(ItemsByTagItem, { tagName: tag }, taggedOperations.map(function (_a) {
                    var name = _a.name, data = _a.data;
                    return (React.createElement(OperationItem, __assign({ key: name }, data)));
                }))));
        }),
        untagged.length > 0 ? (React.createElement("li", null,
            React.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var name = _a.name, data = _a.data;
                return (React.createElement(OperationItem, __assign({ key: name }, data)));
            })))) : null));
};
var OperationItem = function (_a) {
    var type = _a.type, operationHrefId = _a.operationHrefId, label = _a.label;
    var config = useConfig();
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    var specV = useSpec().version();
    var version = specV.localeCompare('2.6.0', undefined, { numeric: true });
    var isAsyncAPIv2 = version === 0;
    var _b = CommonHelpers.getOperationDesignInformation({
        type: type,
        config: config,
        isAsyncAPIv2: isAsyncAPIv2,
    }), typeLabel = _b.typeLabel, backgroundColor = _b.backgroundColor;
    var bgColors = [
        'bg-red-600',
        'bg-orange-600',
        'bg-green-600',
        'bg-blue-600',
    ];
    return (React.createElement("li", { key: "menu-operation-list-".concat(operationHrefId) },
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#".concat(operationHrefId), onClick: function () { return setShowSidebar(false); } },
            React.createElement("strong", { className: "h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs ".concat(bgColors.includes(backgroundColor) && backgroundColor), title: typeLabel }, typeLabel),
            React.createElement("span", { className: "break-all inline-block" }, label))));
};
var ServerItem = function (_a) {
    var serverName = _a.serverName;
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    return (React.createElement("li", null,
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#server-".concat(serverName), onClick: function () { return setShowSidebar(false); } },
            React.createElement("span", { className: "break-all inline-block" }, serverName))));
};
var ItemsByTagItem = function (_a) {
    var tagName = _a.tagName, children = _a.children;
    var _b = useState(false), expand = _b[0], setExpand = _b[1];
    return (React.createElement("div", null,
        React.createElement(CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                className: expand ? '-rotate-180' : '-rotate-90',
            } },
            React.createElement("span", { className: "text-sm inline-block mt-1 font-extralight" }, tagName)),
        React.createElement("ul", { className: "".concat(expand ? 'block' : 'hidden', " text-sm mt-2 font-light") }, children)));
};
//# sourceMappingURL=Sidebar.js.map