// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Status is an optional final status for this span. Semantically, when Status was not
// set, that means the span ended without errors and to assume Status.Ok (code = 0).
type Status struct {
	Message string
	Code    StatusCode
}

var (
	protoPoolStatus = sync.Pool{
		New: func() any {
			return &Status{}
		},
	}
)

func NewStatus() *Status {
	if !UseProtoPooling.IsEnabled() {
		return &Status{}
	}
	return protoPoolStatus.Get().(*Status)
}

func DeleteStatus(orig *Status, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolStatus.Put(orig)
	}
}

func CopyStatus(dest, src *Status) *Status {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewStatus()
	}
	dest.Message = src.Message
	dest.Code = src.Code

	return dest
}

func CopyStatusSlice(dest, src []Status) []Status {
	var newDest []Status
	if cap(dest) < len(src) {
		newDest = make([]Status, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteStatus(&dest[i], false)
		}
	}
	for i := range src {
		CopyStatus(&newDest[i], &src[i])
	}
	return newDest
}

func CopyStatusPtrSlice(dest, src []*Status) []*Status {
	var newDest []*Status
	if cap(dest) < len(src) {
		newDest = make([]*Status, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewStatus()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteStatus(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewStatus()
		}
	}
	for i := range src {
		CopyStatus(newDest[i], src[i])
	}
	return newDest
}

func (orig *Status) Reset() {
	*orig = Status{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Status) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Message != "" {
		dest.WriteObjectField("message")
		dest.WriteString(orig.Message)
	}

	if int32(orig.Code) != 0 {
		dest.WriteObjectField("code")
		dest.WriteInt32(int32(orig.Code))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Status) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "message":
			orig.Message = iter.ReadString()
		case "code":
			orig.Code = StatusCode(iter.ReadEnumValue(StatusCode_value))
		default:
			iter.Skip()
		}
	}
}

func (orig *Status) SizeProto() int {
	var n int
	var l int
	_ = l

	l = len(orig.Message)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Code != StatusCode(0) {
		n += 1 + proto.Sov(uint64(orig.Code))
	}
	return n
}

func (orig *Status) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Message)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Message)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	if orig.Code != StatusCode(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Code))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func (orig *Status) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Message = string(buf[startPos:pos])

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Code = StatusCode(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestStatus() *Status {
	orig := NewStatus()
	orig.Message = "test_message"
	orig.Code = StatusCode(13)
	return orig
}

func GenTestStatusPtrSlice() []*Status {
	orig := make([]*Status, 5)
	orig[0] = NewStatus()
	orig[1] = GenTestStatus()
	orig[2] = NewStatus()
	orig[3] = GenTestStatus()
	orig[4] = NewStatus()
	return orig
}

func GenTestStatusSlice() []Status {
	orig := make([]Status, 5)
	orig[1] = *GenTestStatus()
	orig[3] = *GenTestStatus()
	return orig
}
