package io.cucumber.gherkin;

import org.jspecify.annotations.Nullable;

import static java.util.stream.Collectors.joining;

class TokenFormatter {

    String formatToken(Token token) {
        if (token.isEOF())
            return "EOF";

        return "(%s:%s)%s:%s/%s/%s".formatted(
                toString(token.location.getLine()),
                toString(token.location.getColumn().orElse(0)),
                toString(token.matchedType),
                token.matchedKeyword == null ? "" : "(%s)%s".formatted(
                                                                  toString(token.keywordType),
                                                                  toString(token.matchedKeyword)),
                toString(token.matchedText),
                toString(token.matchedItems == null ? "" : token.matchedItems.stream()
                        .map(o ->  o.column + ":" + o.text)
                        .collect(joining(",")))
        );
    }

    private String toString(@Nullable Object o) {
        return o == null ? "" : o.toString();
    }
}
