/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.CountingOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/FileData;", "", "dir", "Ljava/nio/file/Path;", "logFilePathProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ljava/io/File;", "<init>", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "logFile", "countingOutputStream", "Lcom/intellij/internal/statistic/eventLog/CountingOutputStream;", "isInitialized", "", "initialize", "", "close", "getLogFile", "getCountingOutputStream", "intellij.platform.statistics"})
final class FileData {
    @NotNull
    private final Path dir;
    @NotNull
    private final Function1<Path, File> logFilePathProvider;
    @Nullable
    private File logFile;
    @Nullable
    private CountingOutputStream countingOutputStream;

    public FileData(@NotNull Path dir, @NotNull Function1<? super Path, ? extends File> logFilePathProvider) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(logFilePathProvider, (String)"logFilePathProvider");
        this.dir = dir;
        this.logFilePathProvider = logFilePathProvider;
    }

    private final boolean isInitialized() {
        return this.logFile != null && this.countingOutputStream != null;
    }

    public final void initialize() {
        File file = this.logFile = (File)this.logFilePathProvider.invoke((Object)this.dir);
        Intrinsics.checkNotNull((Object)file);
        file.getParentFile().mkdirs();
        File file2 = this.logFile;
        Intrinsics.checkNotNull((Object)file2);
        file2.createNewFile();
        File file3 = this.logFile;
        Intrinsics.checkNotNull((Object)file3);
        this.countingOutputStream = new CountingOutputStream(new BufferedOutputStream(new FileOutputStream(file3)));
    }

    public final void close() {
        if (this.isInitialized()) {
            CountingOutputStream countingOutputStream = this.countingOutputStream;
            Intrinsics.checkNotNull((Object)countingOutputStream);
            countingOutputStream.flush();
            CountingOutputStream countingOutputStream2 = this.countingOutputStream;
            Intrinsics.checkNotNull((Object)countingOutputStream2);
            countingOutputStream2.close();
            this.countingOutputStream = null;
            this.logFile = null;
        }
    }

    @NotNull
    public final File getLogFile() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        File file = this.logFile;
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    @NotNull
    public final CountingOutputStream getCountingOutputStream() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        CountingOutputStream countingOutputStream = this.countingOutputStream;
        Intrinsics.checkNotNull((Object)countingOutputStream);
        return countingOutputStream;
    }
}

