/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.format.TrackedOffsetList;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private final boolean parserTrimCellWhiteSpace;
    private MarkdownTable myTable;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.parserTrimCellWhiteSpace = TablesExtension.TRIM_CELL_WHITESPACE.get(options);
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<TableBlock>(TableBlock.class, this::render), new NodeFormattingHandler<TableHead>(TableHead.class, this::render), new NodeFormattingHandler<TableSeparator>(TableSeparator.class, this::render), new NodeFormattingHandler<TableBody>(TableBody.class, this::render), new NodeFormattingHandler<TableRow>(TableRow.class, this::render), new NodeFormattingHandler<TableCell>(TableCell.class, this::render), new NodeFormattingHandler<TableCaption>(TableCaption.class, this::render), new NodeFormattingHandler<Text>(Text.class, this::render)));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable = new MarkdownTable((CharSequence)node.getChars(), this.options);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: 
            case TRANSLATED: {
                markdown.blankLine();
                context.renderChildren(node);
                markdown.tailBlankLine();
                break;
            }
            default: {
                context.renderChildren(node);
                TrackedOffsetList trackedOffsets = context.getTrackedOffsets();
                TrackedOffsetList tableTrackedOffsets = trackedOffsets.getTrackedOffsets(node.getStartOffset(), node.getEndOffset());
                if (!trackedOffsets.isEmpty()) {
                    for (TrackedOffset trackedOffset : tableTrackedOffsets) {
                        assert (trackedOffset.getOffset() >= node.getStartOffset() && trackedOffset.getOffset() <= node.getEndOffset());
                        this.myTable.addTrackedOffset(trackedOffset);
                    }
                }
                if (this.options.tableManipulator != TableManipulator.NULL) {
                    this.myTable.normalize();
                    this.options.tableManipulator.apply(this.myTable, node);
                }
                if (this.myTable.getMaxColumns() <= 0) break;
                markdown.blankLine();
                BasedSequence prefix = markdown.getPrefix();
                this.myTable.setFormatTableIndentPrefix(prefix);
                MarkdownWriter formattedTable = new MarkdownWriter(markdown.getOptions());
                this.myTable.appendTable(formattedTable);
                List<TrackedOffset> tableOffsets = this.myTable.getTrackedOffsets();
                int startOffset = markdown.offsetWithPending();
                if (!tableTrackedOffsets.isEmpty()) {
                    assert (tableTrackedOffsets.size() == tableOffsets.size());
                    for (TrackedOffset trackedOffset : tableTrackedOffsets) {
                        assert (trackedOffset.getOffset() >= node.getStartOffset() && trackedOffset.getOffset() <= node.getEndOffset());
                        if (!trackedOffset.isResolved()) continue;
                        trackedOffset.setIndex(trackedOffset.getIndex() + startOffset);
                    }
                }
                ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.pushPrefix()).setPrefix("", false)).pushOptions()).removeOptions(LineAppendable.F_WHITESPACE_REMOVAL).append(formattedTable).popOptions().popPrefix(false);
                markdown.tailBlankLine();
                if (this.myTable.getMaxColumns() <= 0 || tableTrackedOffsets.isEmpty() || !this.options.dumpIntellijOffsets) break;
                ((MarkdownWriter)markdown.append("\nTracked Offsets")).line();
                String sep = "  ";
                int i = 0;
                for (TrackedOffset trackedOffset : tableOffsets) {
                    ((MarkdownWriter)markdown.append(sep)).append(String.format(Locale.US, "%d:[%d,%d] was:[%d,%d]", ++i, trackedOffset.getIndex(), trackedOffset.getIndex() + 1, trackedOffset.getOffset(), trackedOffset.getOffset() + 1));
                    sep = " ";
                }
                markdown.append("\n");
            }
        }
        this.myTable = null;
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        context.renderChildren(node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(true);
        context.renderChildren(node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        context.renderChildren(node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren(node);
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            if (!this.myTable.isSeparator()) {
                this.myTable.nextRow();
            }
        } else {
            markdown.line();
        }
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            this.myTable.setCaptionWithMarkers(node, node.getOpeningMarker(), node.getText(), node.getClosingMarker());
        } else {
            String dummyCaption = node.hasChildren() ? "dummy" : "";
            String formattedCaption = MarkdownTable.formattedCaption(BasedSequence.of(dummyCaption).subSequence(0, dummyCaption.length()), this.options);
            if (formattedCaption != null) {
                ((MarkdownWriter)markdown.line()).append(node.getOpeningMarker());
                context.renderChildren(node);
                ((MarkdownWriter)markdown.append(node.getClosingMarker())).line();
            }
        }
    }

    private void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            BasedSequence text2 = node.getText();
            if (this.options.trimCellWhitespace) {
                text2 = text2.isBlank() && !text2.isEmpty() ? text2.subSequence(0, 1) : (BasedSequence)text2.trim();
            }
            this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell(node, node.getOpeningMarker(), text2, node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
        } else {
            if (node.getPrevious() == null) {
                if (this.options.leadTrailPipes && node.getOpeningMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append(node.getOpeningMarker());
                }
            } else {
                markdown.append(node.getOpeningMarker());
            }
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!node.getText().startsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            String[] childText = new String[]{""};
            context.translatingSpan((context1, writer) -> {
                context1.renderChildren(node);
                childText[0] = writer.toString(-1, -1);
            });
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!childText[0].endsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            if (node.getNext() == null) {
                if (this.options.leadTrailPipes && node.getClosingMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append(node.getClosingMarker());
                }
            } else {
                markdown.append(node.getClosingMarker());
            }
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.myTable != null && this.myTable.isSeparator()) {
            Node parent = node.getAncestorOfType(Paragraph.class);
            if (parent instanceof Paragraph && ((Paragraph)parent).hasTableSeparator()) {
                ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.pushPrefix()).addPrefix(" ")).append(node.getChars())).popPrefix();
            } else {
                markdown.append(node.getChars());
            }
        } else {
            markdown.append(node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

