/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyLiteralSelectionHandler
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        ASTNode node;
        if (e == null) {
            PyLiteralSelectionHandler.$$$reportNull$$$0(0);
        }
        return (node = e.getNode()) != null && PyTokenTypes.STRING_NODES.contains(node.getElementType());
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PyAstStringLiteralExpression literal;
        if (e == null) {
            PyLiteralSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            PyLiteralSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PyLiteralSelectionHandler.$$$reportNull$$$0(3);
        }
        if ((literal = (PyAstStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)e, PyAstStringLiteralExpression.class)) != null) {
            List<TextRange> ranges = literal.getStringValueTextRanges();
            List<ASTNode> nodes = literal.getStringNodes();
            for (int i = 0; i < ranges.size(); ++i) {
                TextRange stringRange = ranges.get(i);
                TextRange offsetRange = stringRange.shiftRight(literal.getTextRange().getStartOffset());
                if (!offsetRange.contains(cursorOffset) || offsetRange.getLength() <= 1) continue;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                SelectWordUtil.addWordHonoringEscapeSequences((CharSequence)editorText, (TextRange)nodes.get(i).getTextRange(), (int)cursorOffset, (Lexer)new PyStringLiteralLexer(nodes.get(i).getElementType()), result);
                result.add(offsetRange);
                return result;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/editor/selectWord/PyLiteralSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

