/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.services;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.services.SshServiceViewContributorKt;
import com.intellij.ssh.services.SshSessionServiceViewContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ssh/services/SshServiceViewContributor;", "Lcom/intellij/execution/services/ServiceViewGroupingContributor;", "Lcom/intellij/ssh/services/SshSessionServiceViewContributor;", "", "<init>", "()V", "getViewDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "getServiceDescriptor", "service", "getGroups", "contributor", "getGroupDescriptor", "group", "intellij.platform.ssh.ui"})
@SourceDebugExtension(value={"SMAP\nSshServiceViewContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshServiceViewContributor.kt\ncom/intellij/ssh/services/SshServiceViewContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1557#2:105\n1628#2,3:106\n*S KotlinDebug\n*F\n+ 1 SshServiceViewContributor.kt\ncom/intellij/ssh/services/SshServiceViewContributor\n*L\n57#1:105\n57#1:106,3\n*E\n"})
public final class SshServiceViewContributor
implements ServiceViewGroupingContributor<SshSessionServiceViewContributor, String> {
    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Icon icon = AllIcons.Debugger.Console;
        return (ServiceViewDescriptor)new ServiceViewToolWindowDescriptor(icon){

            public String getToolWindowId() {
                String string = this.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                return string;
            }

            public Icon getToolWindowIcon() {
                Icon icon = AllIcons.Toolwindows.ToolWindowServices;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowServices");
                return icon;
            }

            public String getStripeTitle() {
                return this.getToolWindowId();
            }

            public boolean isExclusionAllowed() {
                return SshServiceViewContributorKt.isSshServiceViewEnabled();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SshSessionServiceViewContributor> getServices(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (SshServiceViewContributorKt.isSshServiceViewEnabled()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = SshConnectionService.Companion.getInstance().getSessions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SshSession sshSession = (SshSession)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean $i$f$getServices$stub_for_inlining = false;
                boolean bl = false;
                collection.add(new SshSessionServiceViewContributor((SshSession)p0));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull SshSessionServiceViewContributor service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return (ServiceViewDescriptor)SshSessionServiceViewContributor.Companion.getSessionDescriptor();
    }

    @NotNull
    public List<String> getGroups(@NotNull SshSessionServiceViewContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        SshSession session = contributor.asService();
        String portSuffix = session.isConnected() ? ":" + session.getPort() : "";
        return CollectionsKt.listOf((Object)(session.getUserName() + "@" + session.getHost() + portSuffix));
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return (ServiceViewDescriptor)new SimpleServiceViewDescriptor(group, AllIcons.Webreferences.Server);
    }
}

