/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsLogManager;
import git4idea.GitVcs;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import git4idea.log.GitShowExternalLogActionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgit4idea/log/ShowLogTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "vcs", "Lgit4idea/GitVcs;", "testGitExecutable", "", "showLog", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "Lcom/intellij/openapi/Disposable;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitVcs;ZLkotlin/jvm/functions/Function2;)V", "disposable", "Lorg/jetbrains/annotations/NotNull;", "manager", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "intellij.vcs.git"})
final class ShowLogTask
extends Task.Backgroundable {
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final GitVcs vcs;
    private final boolean testGitExecutable;
    @NotNull
    private final Function2<VcsLogManager, Disposable, Unit> showLog;
    @NotNull
    private final Disposable disposable;
    private volatile VcsLogManager manager;

    public ShowLogTask(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull GitVcs vcs, boolean testGitExecutable2, @NotNull Function2<? super VcsLogManager, ? super Disposable, Unit> showLog) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(showLog, (String)"showLog");
        super(project, GitBundle.message("git.log.external.loading.process", new Object[0]), true);
        this.roots = roots;
        this.vcs = vcs;
        this.testGitExecutable = testGitExecutable2;
        this.showLog = showLog;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.testGitExecutable && !GitExecutableManager.getInstance().testGitExecutableVersionValid(this.getProject())) {
            throw new ProcessCanceledException();
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.manager = GitShowExternalLogActionKt.access$createLogManager(project, this.vcs, this.roots, this.disposable);
    }

    public void onSuccess() {
        if (!this.getProject().isDisposed()) {
            VcsLogManager vcsLogManager = this.manager;
            if (vcsLogManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                vcsLogManager = null;
            }
            this.showLog.invoke((Object)vcsLogManager, (Object)this.disposable);
        }
    }
}

