/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.options.impl.GridOptionsImpl;
import org.intellij.images.options.impl.TransparencyChessboardOptionsImpl;
import org.intellij.images.options.impl.ZoomOptionsImpl;
import org.jdom.Element;

final class EditorOptionsImpl
implements EditorOptions,
JDOMExternalizable {
    private final GridOptions gridOptions;
    private final TransparencyChessboardOptions transparencyChessboardOptions;
    private final ZoomOptions zoomOptions;
    private boolean fileNameVisible = true;
    private boolean fileSizeVisible = true;

    EditorOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.gridOptions = new GridOptionsImpl(propertyChangeSupport);
        this.transparencyChessboardOptions = new TransparencyChessboardOptionsImpl(propertyChangeSupport);
        this.zoomOptions = new ZoomOptionsImpl(propertyChangeSupport);
    }

    @Override
    public GridOptions getGridOptions() {
        return this.gridOptions;
    }

    @Override
    public TransparencyChessboardOptions getTransparencyChessboardOptions() {
        return this.transparencyChessboardOptions;
    }

    @Override
    public ZoomOptions getZoomOptions() {
        return this.zoomOptions;
    }

    public EditorOptions clone() throws CloneNotSupportedException {
        return (EditorOptions)super.clone();
    }

    @Override
    public void inject(EditorOptions options) {
        this.gridOptions.inject(options.getGridOptions());
        this.transparencyChessboardOptions.inject(options.getTransparencyChessboardOptions());
        this.zoomOptions.inject(options.getZoomOptions());
    }

    @Override
    public boolean setOption(String name, Object value) {
        return this.gridOptions.setOption(name, value) || this.transparencyChessboardOptions.setOption(name, value) || this.zoomOptions.setOption(name, value);
    }

    @Override
    public boolean isFileNameVisible() {
        return this.fileNameVisible;
    }

    @Override
    public void setFileNameVisible(boolean fileNameVisible) {
        this.fileNameVisible = fileNameVisible;
    }

    @Override
    public void setFileSizeVisible(boolean fileSizeVisible) {
        this.fileSizeVisible = fileSizeVisible;
    }

    @Override
    public boolean isFileSizeVisible() {
        return this.fileSizeVisible;
    }

    public void readExternal(Element element) throws InvalidDataException {
        ((JDOMExternalizable)this.transparencyChessboardOptions).readExternal(element);
        String fileNameVisibleAttr = element.getAttributeValue("fileNameVisible");
        this.fileNameVisible = fileNameVisibleAttr == null || Boolean.parseBoolean(fileNameVisibleAttr);
        String fileSizeVisibleAttr = element.getAttributeValue("fileSizeVisible");
        this.fileSizeVisible = fileNameVisibleAttr == null || Boolean.parseBoolean(fileSizeVisibleAttr);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        ((JDOMExternalizable)this.transparencyChessboardOptions).writeExternal(element);
        if (!this.fileNameVisible) {
            element.setAttribute("fileNameVisible", "false");
        }
        if (!this.fileSizeVisible) {
            element.setAttribute("fileSizeVisible", "false");
        }
    }
}

