/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.impl.XmlStreamUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;

final class ModuleXmlSerializer {
    private static final String MODULE_TAG = "module";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String RESOURCE_ROOT_TAG = "resource-root";
    private static final String PATH_ATTRIBUTE = "path";

    ModuleXmlSerializer() {
    }

    public static void writeModuleXml(@NotNull RawRuntimeModuleDescriptor descriptor, @NotNull PrintWriter output, XMLOutputFactory factory) throws XMLStreamException {
        List<String> roots;
        if (descriptor == null) {
            ModuleXmlSerializer.$$$reportNull$$$0(0);
        }
        if (output == null) {
            ModuleXmlSerializer.$$$reportNull$$$0(1);
        }
        XMLStreamWriter writer = factory.createXMLStreamWriter(output);
        writer.writeStartDocument("UTF-8", "1.0");
        ModuleXmlSerializer.writeEolAndIndent(writer, 0);
        writer.writeStartElement(MODULE_TAG);
        writer.writeAttribute(NAME_ATTRIBUTE, descriptor.getId());
        List<String> dependencies = descriptor.getDependencies();
        if (!dependencies.isEmpty()) {
            ModuleXmlSerializer.writeEolAndIndent(writer, 1);
            writer.writeStartElement("dependencies");
            for (String dependency : dependencies) {
                ModuleXmlSerializer.writeEolAndIndent(writer, 2);
                writer.writeEmptyElement(MODULE_TAG);
                writer.writeAttribute(NAME_ATTRIBUTE, dependency);
            }
            ModuleXmlSerializer.writeEolAndIndent(writer, 1);
            writer.writeEndElement();
        }
        if (!(roots = descriptor.getResourcePaths()).isEmpty()) {
            ModuleXmlSerializer.writeEolAndIndent(writer, 1);
            writer.writeStartElement("resources");
            for (String root : roots) {
                ModuleXmlSerializer.writeEolAndIndent(writer, 2);
                writer.writeEmptyElement(RESOURCE_ROOT_TAG);
                writer.writeAttribute(PATH_ATTRIBUTE, root);
            }
            ModuleXmlSerializer.writeEolAndIndent(writer, 1);
            writer.writeEndElement();
        }
        ModuleXmlSerializer.writeEolAndIndent(writer, 0);
        writer.writeEndElement();
        writer.writeEndDocument();
        output.flush();
    }

    private static void writeEolAndIndent(XMLStreamWriter writer, int indent) throws XMLStreamException {
        writer.writeCharacters("\n");
        for (int i = 0; i < indent; ++i) {
            writer.writeCharacters("  ");
        }
    }

    public static RawRuntimeModuleDescriptor parseModuleXml(XMLInputFactory factory, InputStream inputStream) throws XMLStreamException {
        XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
        ArrayList<String> dependencies = new ArrayList<String>();
        ArrayList<String> resources = new ArrayList<String>();
        String moduleName = null;
        int level = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                String tagName = reader.getLocalName();
                if (++level == 1 && tagName.equals(MODULE_TAG)) {
                    moduleName = XmlStreamUtil.readFirstAttribute(reader, NAME_ATTRIBUTE);
                    continue;
                }
                if (level == 3 & tagName.equals(MODULE_TAG)) {
                    dependencies.add(XmlStreamUtil.readFirstAttribute(reader, NAME_ATTRIBUTE));
                    continue;
                }
                if (level != 3 || !tagName.equals(RESOURCE_ROOT_TAG)) continue;
                String relativePath = XmlStreamUtil.readFirstAttribute(reader, PATH_ATTRIBUTE);
                resources.add(relativePath);
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        reader.close();
        if (moduleName == null) {
            throw new XMLStreamException("Required attribute 'module' is not specified");
        }
        return RawRuntimeModuleDescriptor.create(moduleName, resources, dependencies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "output";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/runtime/repository/serialization/impl/ModuleXmlSerializer";
        objectArray[2] = "writeModuleXml";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

