/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class SaslOutputStream
extends FilterOutputStream {
    private static final boolean debug = false;
    private byte[] lenBuf = new byte[4];
    private int rawSendSize = 65536;
    private SaslClient sc;

    SaslOutputStream(SaslClient saslClient, OutputStream outputStream) throws SaslException {
        super(outputStream);
        this.sc = saslClient;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (string != null) {
            try {
                this.rawSendSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SaslException("javax.security.sasl.rawsendsize property must be numeric string: " + string);
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; i += this.rawSendSize) {
            int n3 = n2 - i < this.rawSendSize ? n2 - i : this.rawSendSize;
            byte[] byArray2 = this.sc.wrap(byArray, n + i, n3);
            SaslOutputStream.intToNetworkByteOrder(byArray2.length, this.lenBuf, 0, 4);
            this.out.write(this.lenBuf, 0, 4);
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    @Override
    public void close() throws IOException {
        SaslException saslException = null;
        try {
            this.sc.dispose();
        }
        catch (SaslException saslException2) {
            saslException = saslException2;
        }
        super.close();
        if (saslException != null) {
            throw saslException;
        }
    }

    private static void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray[n2 + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }
}

