/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;

public enum EventWriterMethod {
    BEGIN_EVENT("(" + jdk.internal.org.objectweb.asm.Type.getType(PlatformEventType.class).getDescriptor() + ")Z", "???", "beginEvent"),
    END_EVENT("()Z", "???", "endEvent"),
    PUT_BYTE("(B)V", "byte", "putByte"),
    PUT_SHORT("(S)V", "short", "putShort"),
    PUT_INT("(I)V", "int", "putInt"),
    PUT_LONG("(J)V", "long", "putLong"),
    PUT_FLOAT("(F)V", "float", "putFloat"),
    PUT_DOUBLE("(D)V", "double", "putDouble"),
    PUT_CHAR("(C)V", "char", "putChar"),
    PUT_BOOLEAN("(Z)V", "boolean", "putBoolean"),
    PUT_THREAD("(Ljava/lang/Thread;)V", Type.THREAD.getName(), "putThread"),
    PUT_CLASS("(Ljava/lang/Class;)V", Type.CLASS.getName(), "putClass"),
    PUT_STRING("(Ljava/lang/String;Ljdk/jfr/internal/StringPool;)V", Type.STRING.getName(), "putString"),
    PUT_EVENT_THREAD("()V", Type.THREAD.getName(), "putEventThread"),
    PUT_STACK_TRACE("()V", "jdk.types.StackTrace", "putStackTrace");

    private final Method asmMethod;
    private final String typeDescriptor;

    private EventWriterMethod(String string2, String string3, String string4) {
        this.typeDescriptor = ASMToolkit.getDescriptor(string3);
        this.asmMethod = new Method(string4, string2);
    }

    public Method asASM() {
        return this.asmMethod;
    }

    public static EventWriterMethod lookupMethod(EventInstrumentation.FieldInfo fieldInfo) {
        if (fieldInfo.fieldName.equals("eventThread")) {
            return PUT_EVENT_THREAD;
        }
        for (EventWriterMethod eventWriterMethod : EventWriterMethod.values()) {
            if (!fieldInfo.fieldDescriptor.equals(eventWriterMethod.typeDescriptor)) continue;
            return eventWriterMethod;
        }
        throw new Error("Unknown type " + fieldInfo.fieldDescriptor);
    }
}

