/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassChooserDialog
extends JDialog {
    JarEntryTreeNode m_root;
    private boolean m_valid = false;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton m_buttonCancel;
    private JButton m_buttonSelect;
    private JTree m_tree;

    public ClassChooserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void clear() {
        JarEntryTreeNode root;
        this.m_root = root = new JarEntryTreeNode("Available Classes");
        this.m_tree.setModel(new DefaultTreeModel(this.m_root));
    }

    public void addJar(JarFile jf) {
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String[] res = entry.toString().split("/");
            if (res.length <= 0 || !res[res.length - 1].toLowerCase().endsWith(".class")) continue;
            String rs = res[res.length - 1];
            res[res.length - 1] = rs = rs.substring(0, rs.length() - 6);
            this.m_root.add(res);
        }
    }

    public void setJar(JarFile jf) {
        JarEntryTreeNode root;
        this.m_root = root = new JarEntryTreeNode(jf.getName());
        this.m_tree.setModel(new DefaultTreeModel(root));
    }

    public String getClassName() {
        TreePath path = this.m_tree.getSelectionPath();
        Object[] objs = path.getPath();
        StringBuffer cname = new StringBuffer();
        for (int i = 1; i < objs.length; ++i) {
            if (i > 1) {
                cname.append(".");
            }
            cname.append(((JarEntryTreeNode)objs[i]).getUserObject().toString());
        }
        return cname.toString();
    }

    public void setClassName(String classname) {
        if (this.m_root == null) {
            return;
        }
        String[] res = classname.split("[.]");
        JarEntryTreeNode node = this.m_root;
        JarEntryTreeNode best = this.m_root;
        for (int i = 0; i < res.length; ++i) {
            String item = res[i];
            JarEntryTreeNode next = null;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                JarEntryTreeNode opt = (JarEntryTreeNode)e.nextElement();
                if (!item.equals(opt.getUserObject())) continue;
                next = opt;
            }
            node = next;
            if (node == null) continue;
            best = node;
        }
        TreePath tp = new TreePath(best.getPath());
        this.m_tree.setSelectionPath(tp);
        this.m_tree.makeVisible(tp);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.m_tree = new JTree();
        this.jPanel2 = new JPanel();
        this.m_buttonSelect = new JButton();
        this.jSeparator1 = new JSeparator();
        this.m_buttonCancel = new JButton();
        this.setTitle("Class Selector");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ClassChooserDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jPanel1.setFocusable(false);
        this.jLabel1.setText("Select a class...");
        this.jLabel1.setFocusable(false);
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jPanel3.setFocusable(false);
        this.jScrollPane1.setFocusable(false);
        this.jScrollPane1.setViewportView(this.m_tree);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setFocusable(false);
        this.m_buttonSelect.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_calc-accept-16.png")));
        this.m_buttonSelect.setText("Select");
        this.m_buttonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassChooserDialog.this.buttonSelectActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_buttonSelect);
        this.jPanel2.add(this.jSeparator1);
        this.m_buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_calc-cancel-16.png")));
        this.m_buttonCancel.setText("Cancel");
        this.m_buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassChooserDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_buttonCancel);
        this.getContentPane().add((Component)this.jPanel2, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 371) / 2, (screenSize.height - 260) / 2, 371, 260);
    }

    private void buttonSelectActionPerformed(ActionEvent evt) {
        this.m_valid = true;
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.m_valid = false;
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.m_valid = false;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ClassChooserDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public boolean validated() {
        return this.m_valid;
    }

    public class JarEntryTreeNode
    extends DefaultMutableTreeNode {
        public JarEntryTreeNode(String value) {
            super(value);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            URL imgurl = this.getClass().getResource("/icons/stock_form-autopilots-16.png");
            if (imgurl != null) {
                ImageIcon leaf = new ImageIcon(imgurl);
                renderer.setLeafIcon(leaf);
            }
            ClassChooserDialog.this.m_tree.setCellRenderer(renderer);
            ClassChooserDialog.this.m_tree.addTreeSelectionListener(new ClassTreeListener());
            ClassChooserDialog.this.m_tree.setEditable(false);
        }

        public void add(String[] items) {
            JarEntryTreeNode current = this;
            for (int i = 0; i < items.length; ++i) {
                JarEntryTreeNode next = null;
                Enumeration<TreeNode> e = current.children();
                while (e.hasMoreElements() && next == null) {
                    JarEntryTreeNode jtn = (JarEntryTreeNode)e.nextElement();
                    if (!jtn.getUserObject().equals(items[i])) continue;
                    next = jtn;
                }
                if (next == null) {
                    next = new JarEntryTreeNode(items[i]);
                    current.add(next);
                    current = next;
                    continue;
                }
                current = next;
            }
        }
    }

    public class ClassTreeListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            TreePath tp = e.getPath();
            JarEntryTreeNode last = (JarEntryTreeNode)tp.getLastPathComponent();
            if (last.getChildCount() > 0) {
                ClassChooserDialog.this.m_buttonSelect.setEnabled(false);
            } else {
                ClassChooserDialog.this.m_buttonSelect.setEnabled(true);
            }
        }
    }
}

