/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSMutableRect;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRuntime;
import com.apple.cocoa.foundation.NSSize;
import java.awt.Rectangle;

public class NSRect
implements Cloneable {
    public static final int MinXEdge = 0;
    public static final int MinYEdge = 1;
    public static final int MaxXEdge = 2;
    public static final int MaxYEdge = 3;
    public static final NSRect ZeroRect;
    float _x = 0.0f;
    float _y = 0.0f;
    float _width = 0.0f;
    float _height = 0.0f;

    public NSRect() {
    }

    public NSRect(float f, float f2, float f3, float f4) {
        if (f != f || f2 != f2 || f3 != f3 || f4 != f4) {
            throw new IllegalArgumentException("cannot create NSRect with NaN x (" + f + ") or y (" + f2 + ") or width (" + f3 + ") or height (" + f4 + ")");
        }
        if (0.0f <= f3 && 0.0f <= f4) {
            this._x = f;
            this._y = f2;
            this._width = 0.0f == f3 ? 0.0f : f3;
            this._height = 0.0f == f4 ? 0.0f : f4;
            return;
        }
        throw new IllegalArgumentException("cannot create NSRect with negative width (" + f3 + ") or height (" + f4 + ")");
    }

    public NSRect(NSPoint nSPoint, NSSize nSSize) {
        this(nSPoint.x(), nSPoint.y(), nSSize.width(), nSSize.height());
    }

    public NSRect(NSPoint nSPoint, NSPoint nSPoint2) {
        this(nSPoint.x() < nSPoint2.x() ? nSPoint.x() : nSPoint2.x(), nSPoint.y() < nSPoint2.y() ? nSPoint.y() : nSPoint2.y(), nSPoint.x() < nSPoint2.x() ? nSPoint2.x() - nSPoint.x() : nSPoint.x() - nSPoint2.x(), nSPoint.y() < nSPoint2.y() ? nSPoint2.y() - nSPoint.y() : nSPoint.y() - nSPoint2.y());
    }

    public NSRect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public NSRect(NSRect nSRect) {
        this(nSRect.x(), nSRect.y(), nSRect.width(), nSRect.height());
    }

    private static boolean is_float_char(char c) {
        return '0' <= c && c <= '9' || '+' == c || '-' == c || '.' == c;
    }

    public static NSRect fromString(String string) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        while (n < n2 && !NSRect.is_float_char(cArray[n])) {
            ++n;
        }
        int n3 = n;
        while (n3 < n2 && NSRect.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f = new Float(string.substring(n, n3)).floatValue();
        n = n3;
        while (n < n2 && !NSRect.is_float_char(cArray[n])) {
            ++n;
        }
        n3 = n;
        while (n3 < n2 && NSRect.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f2 = new Float(string.substring(n, n3)).floatValue();
        n = n3;
        while (n < n2 && !NSRect.is_float_char(cArray[n])) {
            ++n;
        }
        n3 = n;
        while (n3 < n2 && NSRect.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f3 = new Float(string.substring(n, n3)).floatValue();
        n = n3;
        while (n < n2 && !NSRect.is_float_char(cArray[n])) {
            ++n;
        }
        n3 = n;
        while (n3 < n2 && NSRect.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f4 = new Float(string.substring(n, n3)).floatValue();
        return new NSRect(f, f2, f3, f4);
    }

    public float x() {
        return this._x;
    }

    public float y() {
        return this._y;
    }

    public float width() {
        return this._width;
    }

    public float height() {
        return this._height;
    }

    public float maxX() {
        return this.x() + this.width();
    }

    public float maxY() {
        return this.y() + this.height();
    }

    public float midX() {
        return this.x() + this.width() / 2.0f;
    }

    public float midY() {
        return this.y() + this.height() / 2.0f;
    }

    public NSPoint origin() {
        return new NSPoint(this.x(), this.y());
    }

    public NSSize size() {
        return new NSSize(this.width(), this.height());
    }

    public boolean isEqualToRect(NSRect nSRect) {
        return nSRect.x() == this.x() && nSRect.y() == this.y() && nSRect.width() == this.width() && nSRect.height() == this.height();
    }

    public boolean equals(Object object) {
        if (object instanceof NSRect) {
            return this.isEqualToRect((NSRect)object);
        }
        return false;
    }

    public int hashCode() {
        return Math.round(this.x() + this.width() / 2.0f + this.y() + this.height() / 2.0f);
    }

    public boolean isEmpty() {
        return this.width() <= 0.0f || this.height() <= 0.0f;
    }

    public NSRect rectByInsettingRect(float f, float f2) {
        return new NSRect(this.x() + f, this.y() + f2, this.width() - f - f, this.height() - f2 - f2);
    }

    public NSRect rectByOffsettingRect(float f, float f2) {
        return new NSRect(this.x() + f, this.y() + f2, this.width(), this.height());
    }

    public NSRect rectByMakingIntegral() {
        float f = this.width();
        float f2 = this.height();
        float f3 = this.x();
        float f4 = this.y();
        float f5 = (float)Math.floor(f3);
        float f6 = (float)Math.floor(f4);
        return new NSRect(f5, f6, (float)Math.ceil(f3 + f) - f5, (float)Math.ceil(f4 + f2) - f6);
    }

    public NSRect rectByUnioningRect(NSRect nSRect) {
        float f = nSRect.width();
        float f2 = nSRect.height();
        float f3 = this.width();
        float f4 = this.height();
        if (f <= 0.0f || f2 <= 0.0f) {
            if (f3 <= 0.0f || f4 <= 0.0f) {
                return ZeroRect;
            }
            return new NSRect(this);
        }
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new NSRect(nSRect);
        }
        float f5 = nSRect.x();
        float f6 = nSRect.y();
        float f7 = this.x();
        float f8 = this.y();
        float f9 = f7 <= f5 ? f7 : f5;
        float f10 = f8 <= f6 ? f8 : f6;
        float f11 = (f7 + f3 >= f5 + f ? f7 + f3 : f5 + f) - f9;
        float f12 = (f8 + f4 >= f6 + f2 ? f8 + f4 : f6 + f2) - f10;
        return new NSRect(f9, f10, f11, f12);
    }

    public NSRect rectByIntersectingRect(NSRect nSRect) {
        float f;
        float f2;
        float f3 = this.width();
        float f4 = this.height();
        float f5 = nSRect.width();
        float f6 = nSRect.height();
        if (f3 <= 0.0f || f4 <= 0.0f || f5 <= 0.0f || f6 <= 0.0f) {
            return ZeroRect;
        }
        float f7 = this.x();
        float f8 = f7 >= (f2 = nSRect.x()) ? f7 : f2;
        float f9 = f = f7 <= f2 ? (f7 += f3) : (f2 += f5);
        if (f <= f8) {
            return ZeroRect;
        }
        float f10 = f8;
        float f11 = f - f8;
        f7 = this.y();
        f8 = f7 >= (f2 = nSRect.y()) ? f7 : f2;
        float f12 = f = f7 <= f2 ? (f7 += f4) : (f2 += f6);
        if (f <= f8) {
            return ZeroRect;
        }
        float f13 = f8;
        float f14 = f - f8;
        return new NSRect(f10, f13, f11, f14);
    }

    public void sliceRect(float f, int n, NSMutableRect nSMutableRect, NSMutableRect nSMutableRect2) {
        float f2 = this.width();
        float f3 = this.height();
        float f4 = this.x();
        float f5 = this.y();
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        float f10 = f2;
        float f11 = f3;
        if (n == 0 || n == 2) {
            if (f > f2) {
                f = f2;
            }
            f6 = f;
            f10 -= f;
            if (n == 0) {
                f8 += f6;
            } else {
                f4 += f10;
            }
        } else {
            if (f > f3) {
                f = f3;
            }
            f7 = f;
            f11 -= f;
            if (n == 1) {
                f9 += f7;
            } else {
                f5 += f11;
            }
        }
        if (nSMutableRect != null) {
            nSMutableRect.setX(f4);
            nSMutableRect.setY(f5);
            nSMutableRect.setWidth(f6);
            nSMutableRect.setHeight(f7);
        }
        if (nSMutableRect2 != null) {
            nSMutableRect2.setX(f8);
            nSMutableRect2.setY(f9);
            nSMutableRect2.setWidth(f10);
            nSMutableRect2.setHeight(f11);
        }
    }

    public boolean containsPoint(NSPoint nSPoint, boolean bl) {
        float f = this.x();
        float f2 = this.y();
        float f3 = nSPoint.x();
        float f4 = nSPoint.y();
        return f <= f3 && f3 < f + this.width() && (bl ? f2 <= f4 && f4 < f2 + this.height() : f2 < f4 && f4 <= f2 + this.height());
    }

    public boolean intersectsRect(NSRect nSRect) {
        float f = this.x();
        float f2 = this.y();
        float f3 = this.width();
        float f4 = this.height();
        float f5 = nSRect.x();
        float f6 = nSRect.y();
        float f7 = nSRect.width();
        float f8 = nSRect.height();
        if (f3 <= 0.0f || f4 <= 0.0f || f7 <= 0.0f || f8 <= 0.0f) {
            return false;
        }
        if (f < f5 ? f + f3 <= f5 : f5 + f7 <= f) {
            return false;
        }
        return !(f2 < f6 ? f2 + f4 <= f6 : f6 + f8 <= f2);
    }

    public boolean isSubrectOfRect(NSRect nSRect) {
        float f = this.x();
        float f2 = this.y();
        float f3 = this.width();
        float f4 = this.height();
        float f5 = nSRect.x();
        float f6 = nSRect.y();
        float f7 = nSRect.width();
        float f8 = nSRect.height();
        boolean bl = 0.0 < (double)f3 && 0.0 < (double)f4 && 0.0 < (double)f7 && 0.0 < (double)f8;
        return bl && f5 <= f && f6 <= f2 && f + f3 <= f5 + f7 && f2 + f4 <= f6 + f8;
    }

    public String toString() {
        return "{{" + this.x() + ", " + this.y() + "}, {" + this.width() + ", " + this.height() + "}}";
    }

    public Rectangle toAWTRectangle() {
        NSRect nSRect = this.rectByMakingIntegral();
        return new Rectangle((int)nSRect.x(), (int)nSRect.y(), (int)nSRect.width(), (int)nSRect.height());
    }

    public Object clone() {
        return new NSRect(this);
    }

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
        ZeroRect = new NSRect();
    }
}

