package test.invokedmethodlistener;

import java.util.List;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.collections.Lists;

public class InvokedMethodListener implements IInvokedMethodListener {

  private final List<IInvokedMethod> m_methods = Lists.newArrayList();

  @Override
  public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    m_methods.add(method);
  }

  public List<IInvokedMethod> getInvokedMethods() {
    return m_methods;
  }
}
