/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class ToolchainBuildOptions
extends BuildOptionSet<ToolchainConfiguration> {
    private final List<? extends BuildOption<? super ToolchainConfiguration>> options = Arrays.asList(new AbstractBuildOption[]{new JavaInstallationPathsOption(), new JavaInstallationEnvironmentPathsOption(), new AutoDetectionOption(), new AutoDownloadOption(), new IntellijJdkBuildOption()});

    public List<? extends BuildOption<? super ToolchainConfiguration>> getAllOptions() {
        return this.options;
    }

    private static class JavaInstallationPathsOption
    extends StringBuildOption<ToolchainConfiguration> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.paths";

        public JavaInstallationPathsOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
            settings.setInstallationsFromPaths(Arrays.asList(value.split(",")));
        }
    }

    private static class JavaInstallationEnvironmentPathsOption
    extends StringBuildOption<ToolchainConfiguration> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.fromEnv";

        public JavaInstallationEnvironmentPathsOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
            settings.setJavaInstallationsFromEnvironment(Arrays.asList(value.split(",")));
        }
    }

    private static class AutoDetectionOption
    extends BooleanBuildOption<ToolchainConfiguration> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.auto-detect";

        public AutoDetectionOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, ToolchainConfiguration settings, Origin origin) {
            settings.setAutoDetectEnabled(value);
        }
    }

    private static class AutoDownloadOption
    extends BooleanBuildOption<ToolchainConfiguration> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.auto-download";

        public AutoDownloadOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, ToolchainConfiguration settings, Origin origin) {
            settings.setDownloadEnabled(value);
        }
    }

    private static class IntellijJdkBuildOption
    extends StringBuildOption<ToolchainConfiguration> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.idea-jdks-directory";

        public IntellijJdkBuildOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
            settings.setIntelliJdkDirectory(new File(value));
        }
    }
}

