// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type KeyValue struct {
	Value AnyValue
	Key   string
}

var (
	protoPoolKeyValue = sync.Pool{
		New: func() any {
			return &KeyValue{}
		},
	}
)

func NewKeyValue() *KeyValue {
	if !UseProtoPooling.IsEnabled() {
		return &KeyValue{}
	}
	return protoPoolKeyValue.Get().(*KeyValue)
}

func DeleteKeyValue(orig *KeyValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteAnyValue(&orig.Value, false)
	orig.Reset()
	if nullable {
		protoPoolKeyValue.Put(orig)
	}
}

func CopyKeyValue(dest, src *KeyValue) *KeyValue {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewKeyValue()
	}
	dest.Key = src.Key
	CopyAnyValue(&dest.Value, &src.Value)

	return dest
}

func CopyKeyValueSlice(dest, src []KeyValue) []KeyValue {
	var newDest []KeyValue
	if cap(dest) < len(src) {
		newDest = make([]KeyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValue(&dest[i], false)
		}
	}
	for i := range src {
		CopyKeyValue(&newDest[i], &src[i])
	}
	return newDest
}

func CopyKeyValuePtrSlice(dest, src []*KeyValue) []*KeyValue {
	var newDest []*KeyValue
	if cap(dest) < len(src) {
		newDest = make([]*KeyValue, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValue()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValue(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValue()
		}
	}
	for i := range src {
		CopyKeyValue(newDest[i], src[i])
	}
	return newDest
}

func (orig *KeyValue) Reset() {
	*orig = KeyValue{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *KeyValue) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Key != "" {
		dest.WriteObjectField("key")
		dest.WriteString(orig.Key)
	}
	dest.WriteObjectField("value")
	orig.Value.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *KeyValue) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "key":
			orig.Key = iter.ReadString()
		case "value":

			orig.Value.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *KeyValue) SizeProto() int {
	var n int
	var l int
	_ = l

	l = len(orig.Key)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.Value.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *KeyValue) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Key)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Key)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = orig.Value.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func (orig *KeyValue) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Key = string(buf[startPos:pos])

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Value.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestKeyValue() *KeyValue {
	orig := NewKeyValue()
	orig.Key = "test_key"
	orig.Value = *GenTestAnyValue()
	return orig
}

func GenTestKeyValuePtrSlice() []*KeyValue {
	orig := make([]*KeyValue, 5)
	orig[0] = NewKeyValue()
	orig[1] = GenTestKeyValue()
	orig[2] = NewKeyValue()
	orig[3] = GenTestKeyValue()
	orig[4] = NewKeyValue()
	return orig
}

func GenTestKeyValueSlice() []KeyValue {
	orig := make([]KeyValue, 5)
	orig[1] = *GenTestKeyValue()
	orig[3] = *GenTestKeyValue()
	return orig
}
