/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import proguard.io.DataEntryReader;
import proguard.io.DataEntrySource;
import proguard.io.FileDataEntry;

public class DirectorySource
implements DataEntrySource {
    private final File directory;

    public DirectorySource(File directory) {
        this.directory = directory;
    }

    @Override
    public void pumpDataEntries(DataEntryReader dataEntryReader) throws IOException {
        if (!this.directory.exists()) {
            throw new IOException("No such file or directory: " + this.directory);
        }
        this.readFiles(this.directory, dataEntryReader);
    }

    private void readFiles(File file, DataEntryReader dataEntryReader) throws IOException {
        dataEntryReader.read(new FileDataEntry(this.directory, file));
        if (file.isDirectory()) {
            File[] listedFiles = file.listFiles();
            for (int index = 0; index < listedFiles.length; ++index) {
                File listedFile = listedFiles[index];
                try {
                    this.readFiles(listedFile, dataEntryReader);
                    continue;
                }
                catch (IOException e) {
                    throw new IOException("Can't read [" + listedFile.getName() + "] (" + e.getMessage() + ")", e);
                }
            }
        }
    }
}

