/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.optimize.gson.GsonAnnotationCleaner;
import proguard.optimize.gson.GsonConstructorPatcher;
import proguard.optimize.gson.GsonContext;
import proguard.optimize.gson.GsonDeserializationOptimizer;
import proguard.optimize.gson.GsonInstrumentationAdder;
import proguard.optimize.gson.GsonSerializationOptimizer;
import proguard.optimize.gson.OptimizedJsonFieldCollector;
import proguard.optimize.gson.OptimizedJsonFieldVisitor;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedJsonReaderImplInitializer;
import proguard.optimize.gson.OptimizedJsonWriterImplInitializer;
import proguard.optimize.gson.OptimizedTypeAdapterAdder;
import proguard.optimize.gson.OptimizedTypeAdapterFactoryInitializer;
import proguard.pass.Pass;
import proguard.util.ProcessingFlagSetter;
import proguard.util.StringUtil;

public class GsonOptimizer
implements Pass {
    private static final Logger logger = LogManager.getLogger(GsonOptimizer.class);
    public static final boolean DEBUG = false;
    private static final String[] TEMPLATE_CLASSES = new String[]{"proguard/optimize/gson/_OptimizedTypeAdapter", "proguard/optimize/gson/_GsonUtil", "proguard/optimize/gson/_OptimizedJsonReader", "proguard/optimize/gson/_OptimizedJsonReaderImpl", "proguard/optimize/gson/_OptimizedJsonWriter", "proguard/optimize/gson/_OptimizedJsonWriterImpl", "proguard/optimize/gson/_OptimizedTypeAdapterFactory"};
    private final Configuration configuration;

    public GsonOptimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        if (appView.programClassPool.getClass("com/google/gson/Gson") == null) {
            return;
        }
        logger.info("Optimizing usages of Gson library...");
        appView.programClassPool.classesAccept(new ClassNameFilter(StringUtil.join(",", "com/google/gson/Gson", "com/google/gson/internal/Excluder"), (ClassVisitor)new AllFieldVisitor(new MemberAccessSetter(1))));
        appView.programClassPool.classesAccept(new ClassNameFilter("com/google/gson/Gson", (ClassVisitor)new MemberAccessFlagCleaner(16)));
        WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
        GsonContext gsonContext = new GsonContext();
        gsonContext.setupFor(appView.programClassPool, appView.libraryClassPool, warningPrinter);
        if (gsonContext.gsonDomainClassPool.size() > 0) {
            boolean addExcluder;
            OptimizedJsonInfo serializationInfo = new OptimizedJsonInfo();
            OptimizedJsonInfo deserializationInfo = new OptimizedJsonInfo();
            OptimizedJsonFieldCollector serializedFieldCollector = new OptimizedJsonFieldCollector(serializationInfo, OptimizedJsonFieldCollector.Mode.serialize);
            OptimizedJsonFieldCollector deserializedFieldCollector = new OptimizedJsonFieldCollector(deserializationInfo, OptimizedJsonFieldCollector.Mode.deserialize);
            gsonContext.gsonDomainClassPool.classesAccept(new MultiClassVisitor(new OptimizedJsonFieldVisitor(serializedFieldCollector, serializedFieldCollector), new OptimizedJsonFieldVisitor(deserializedFieldCollector, deserializedFieldCollector)));
            gsonContext.gsonDomainClassPool.classesAccept(new GsonAnnotationCleaner(gsonContext.gsonRuntimeSettings));
            serializationInfo.assignIndices();
            deserializationInfo.assignIndices();
            ClassReader helperClassReader = new ClassReader(false, false, false, false, null, new MultiClassVisitor(new ProcessingFlagSetter(512), new ClassPresenceFilter(appView.programClassPool, null, new ClassPoolFiller(appView.programClassPool)), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool), new ClassSubHierarchyInitializer()));
            for (String clazz : TEMPLATE_CLASSES) {
                helperClassReader.read(new ClassPathDataEntry(clazz + ".class"));
                for (Clazz domainClass : gsonContext.gsonDomainClassPool.classes()) {
                    appView.extraDataEntryNameMap.addExtraClassToClass(domainClass.getName(), clazz);
                }
            }
            BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, false);
            appView.programClassPool.classesAccept("proguard/optimize/gson/_OptimizedJsonWriterImpl", (ClassVisitor)new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()[Ljava/lang/String;", (MemberVisitor)new AllAttributeVisitor(new OptimizedJsonWriterImplInitializer(appView.programClassPool, appView.libraryClassPool, codeAttributeEditor, serializationInfo)))))));
            appView.programClassPool.classesAccept("proguard/optimize/gson/_OptimizedJsonReaderImpl", (ClassVisitor)new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()Ljava/util/Map;", (MemberVisitor)new AllAttributeVisitor(new OptimizedJsonReaderImplInitializer(appView.programClassPool, appView.libraryClassPool, codeAttributeEditor, deserializationInfo)))))));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassAccessFilter(0, 16384, new GsonSerializationOptimizer(appView.programClassPool, appView.libraryClassPool, gsonContext.gsonRuntimeSettings, serializationInfo, appView.extraDataEntryNameMap)));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassAccessFilter(0, 16384, new GsonDeserializationOptimizer(appView.programClassPool, appView.libraryClassPool, gsonContext.gsonRuntimeSettings, deserializationInfo, appView.extraDataEntryNameMap)));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
            HashMap<String, String> typeAdapterRegistry = new HashMap<String, String>();
            OptimizedTypeAdapterAdder optimizedTypeAdapterAdder = new OptimizedTypeAdapterAdder(appView.programClassPool, appView.libraryClassPool, codeAttributeEditor, serializationInfo, deserializationInfo, appView.extraDataEntryNameMap, typeAdapterRegistry, gsonContext.gsonRuntimeSettings);
            gsonContext.gsonDomainClassPool.classesAccept(new ClassAccessFilter(0, 1024, optimizedTypeAdapterAdder));
            appView.programClassPool.classAccept("proguard/optimize/gson/_OptimizedTypeAdapterFactory", new MultiClassVisitor(new AllMemberVisitor(new AllAttributeVisitor(new PeepholeEditor(branchTargetFinder, codeAttributeEditor, new OptimizedTypeAdapterFactoryInitializer(appView.programClassPool, codeAttributeEditor, typeAdapterRegistry, gsonContext.gsonRuntimeSettings)))), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool)));
            ProgramClass gsonClass = (ProgramClass)appView.programClassPool.getClass("com/google/gson/Gson");
            MemberCounter memberCounter = new MemberCounter();
            gsonClass.accept(new NamedFieldVisitor("excluder", "Lcom/google/gson/internal/Excluder;", memberCounter));
            boolean bl = addExcluder = memberCounter.getCount() == 0;
            if (addExcluder) {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(gsonClass, appView.programClassPool, appView.libraryClassPool);
                int nameIndex = constantPoolEditor.addUtf8Constant("excluder");
                int descriptorIndex = constantPoolEditor.addUtf8Constant("Lcom/google/gson/internal/Excluder;");
                ProgramField field = new ProgramField(1, nameIndex, descriptorIndex, null);
                ClassEditor classEditor = new ClassEditor(gsonClass);
                classEditor.addField(field);
                gsonClass.fieldsAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
                gsonClass.constantPoolEntriesAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
            }
            appView.programClassPool.classAccept("com/google/gson/Gson", new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("<init>", (MemberVisitor)new GsonConstructorPatcher(codeAttributeEditor, addExcluder))), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool)));
            logger.info("  Number of optimized serializable classes:      {}", (Object)gsonContext.gsonDomainClassPool.size());
            if (logger.getLevel().isLessSpecificThan(Level.DEBUG)) {
                appView.programClassPool.classAccept("com/google/gson/Gson", new AllMethodVisitor(new MultiMemberVisitor(new MemberNameFilter("toJson", (MemberVisitor)new MemberDescriptorFilter(StringUtil.join(",", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Lcom/google/gson/stream/JsonWriter;)V", "(Lcom/google/gson/JsonElement;Lcom/google/gson/stream/JsonWriter;)V"), (MemberVisitor)new AllAttributeVisitor(new PeepholeEditor(branchTargetFinder, codeAttributeEditor, new GsonInstrumentationAdder(appView.programClassPool, appView.libraryClassPool, codeAttributeEditor))))), new MemberNameFilter("fromJson", (MemberVisitor)new MemberDescriptorFilter("(Lcom/google/gson/stream/JsonReader;Ljava/lang/reflect/Type;)Ljava/lang/Object;", (MemberVisitor)new AllAttributeVisitor(new PeepholeEditor(branchTargetFinder, codeAttributeEditor, new GsonInstrumentationAdder(appView.programClassPool, appView.libraryClassPool, codeAttributeEditor))))))));
            }
        }
    }
}

