// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#include "azure/keyvault/secrets/keyvault_deleted_secret.hpp"

#include "./generated/secrets_models.hpp"

namespace Azure { namespace Security { namespace KeyVault { namespace Secrets {
  DeletedSecret::DeletedSecret(_detail::Models::DeletedSecretBundle const& deletedSecret)
  {
    if (deletedSecret.RecoveryId.HasValue())
    {
      RecoveryId = deletedSecret.RecoveryId.Value();
    }
    if (deletedSecret.ScheduledPurgeDate.HasValue())
    {
      ScheduledPurgeDate = deletedSecret.ScheduledPurgeDate.Value();
    }
    if (deletedSecret.DeletedDate.HasValue())
    {
      DeletedOn = deletedSecret.DeletedDate.Value();
    }
    if (deletedSecret.Value.HasValue())
    {
      Value = deletedSecret.Value;
    }
    if (deletedSecret.Id.HasValue())
    {
      Properties = SecretProperties::CreateFromURL(deletedSecret.RecoveryId.Value());
      Id = deletedSecret.Id.Value();
      Properties.Id = deletedSecret.Id.Value();
      Name = Properties.Name;
    }
    if (deletedSecret.ContentType.HasValue())
    {
      Properties.ContentType = deletedSecret.ContentType;
    }
    Properties.KeyId = deletedSecret.Kid;
    if (deletedSecret.Managed.HasValue())
    {
      Properties.Managed = deletedSecret.Managed.Value();
    }
    if (deletedSecret.Attributes.HasValue())
    {
      Properties.ExpiresOn = deletedSecret.Attributes.Value().Expires;
      Properties.NotBefore = deletedSecret.Attributes.Value().NotBefore;
      Properties.Enabled = deletedSecret.Attributes.Value().Enabled;
      Properties.CreatedOn = deletedSecret.Attributes.Value().Created;
      Properties.UpdatedOn = deletedSecret.Attributes.Value().Updated;
      if (deletedSecret.Attributes.Value().RecoverableDays.HasValue())
      {
        Properties.RecoverableDays = deletedSecret.Attributes.Value().RecoverableDays.Value();
      }
    }
    if (deletedSecret.Tags.HasValue())
    {
      Properties.Tags = std::unordered_map<std::string, std::string>(
          deletedSecret.Tags.Value().begin(), deletedSecret.Tags.Value().end());
    }
  }

  DeletedSecret::DeletedSecret(_detail::Models::DeletedSecretItem const& deletedSecret)
  {
    if (deletedSecret.RecoveryId.HasValue())
    {
      RecoveryId = deletedSecret.RecoveryId.Value();
    }
    if (deletedSecret.ScheduledPurgeDate.HasValue())
    {
      ScheduledPurgeDate = deletedSecret.ScheduledPurgeDate.Value();
    }
    if (deletedSecret.DeletedDate.HasValue())
    {
      DeletedOn = deletedSecret.DeletedDate.Value();
    }
    if (deletedSecret.RecoveryId.HasValue())
    {
      Properties = SecretProperties::CreateFromURL(deletedSecret.Id.Value());
      Id = deletedSecret.Id.Value();
      Properties.Id = deletedSecret.Id.Value();
    }
    if (deletedSecret.ContentType.HasValue())
    {
      Properties.ContentType = deletedSecret.ContentType;
    }
    if (deletedSecret.Managed.HasValue())
    {
      Properties.Managed = deletedSecret.Managed.Value();
    }
    if (deletedSecret.Attributes.HasValue())
    {
      Properties.ExpiresOn = deletedSecret.Attributes.Value().Expires;
      Properties.NotBefore = deletedSecret.Attributes.Value().NotBefore;
      Properties.Enabled = deletedSecret.Attributes.Value().Enabled;
      Properties.CreatedOn = deletedSecret.Attributes.Value().Created;
      Properties.UpdatedOn = deletedSecret.Attributes.Value().Updated;
      if (deletedSecret.Attributes.Value().RecoverableDays.HasValue())
      {
        Properties.RecoverableDays = deletedSecret.Attributes.Value().RecoverableDays.Value();
      }
    }
    if (deletedSecret.Tags.HasValue())
    {
      Properties.Tags = std::unordered_map<std::string, std::string>(
          deletedSecret.Tags.Value().begin(), deletedSecret.Tags.Value().end());
    }
  }
}}}} // namespace Azure::Security::KeyVault::Secrets
